/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.resultset;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sparql.resultset.JSONResults;
import com.hp.hpl.jena.sparql.resultset.ResultSetApply;
import com.hp.hpl.jena.sparql.resultset.ResultSetException;
import com.hp.hpl.jena.sparql.resultset.ResultSetProcessor;
import com.hp.hpl.jena.sparql.util.ALog;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONObjectResult
implements ResultSetProcessor,
JSONResults {
    static boolean outputExplicitUnbound = false;
    boolean outputGraphBNodeLabels = ARQ.isTrue(ARQ.outputGraphBNodeLabels);
    int bNodeCounter = 0;
    Map bNodeMap = new HashMap();
    JSONObject json;
    JSONArray solutions;
    JSONObject currentSolution;

    static JSONObject booleanResult(boolean result) {
        try {
            JSONObject json = new JSONObject();
            json.put("head", new JSONObject());
            json.put("boolean", result);
            return json;
        }
        catch (Exception ex) {
            throw new ResultSetException(ex.getMessage(), ex);
        }
    }

    static JSONObject resultSet(ResultSet resultSet) {
        JSONObjectResult xOut = new JSONObjectResult();
        ResultSetApply a = new ResultSetApply(resultSet, xOut);
        a.apply();
        return xOut.json;
    }

    private JSONObjectResult() {
    }

    public void start(ResultSet rs) {
        this.json = new JSONObject();
        try {
            JSONObject head = new JSONObject();
            this.json.put("head", head);
            JSONArray vars = new JSONArray();
            Iterator iter = rs.getResultVars().iterator();
            while (iter.hasNext()) {
                vars.put((String)iter.next());
            }
            head.put("vars", vars);
            JSONObject results = new JSONObject();
            this.json.put("results", results);
            this.solutions = new JSONArray();
            results.put("bindings", this.solutions);
        }
        catch (JSONException ex) {
            throw new ResultSetException(ex.getMessage(), ex);
        }
    }

    public void finish(ResultSet rs) {
    }

    public void start(QuerySolution qs) {
        this.currentSolution = new JSONObject();
        this.solutions.put(this.currentSolution);
    }

    public void finish(QuerySolution qs) {
        this.currentSolution = null;
    }

    public void binding(String varName, RDFNode node) {
        if (node == null && !outputExplicitUnbound) {
            return;
        }
        try {
            JSONObject val = this.valueAsJSON(node);
            this.currentSolution.put(varName, val);
        }
        catch (JSONException ex) {
            throw new ResultSetException(ex.getMessage(), ex);
        }
    }

    private JSONObject valueAsJSON(RDFNode node) throws JSONException {
        JSONObject jsonValue = new JSONObject();
        if (node == null) {
            jsonValue.put("type", "unbound");
            jsonValue.put("value", JSONObject.NULL);
            return jsonValue;
        }
        if (node instanceof Literal) {
            return this.literalAsJSON((Literal)node);
        }
        if (node instanceof Resource) {
            return this.resourceAsJSON((Resource)node);
        }
        ALog.warn(this, "Unknown RDFNode type in result set: " + node.getClass());
        return jsonValue;
    }

    private JSONObject resourceAsJSON(Resource resource) throws JSONException {
        JSONObject jsonValue = new JSONObject();
        if (resource.isAnon()) {
            String label;
            if (this.outputGraphBNodeLabels) {
                label = resource.asNode().getBlankNodeId().getLabelString();
            } else {
                if (!this.bNodeMap.containsKey(resource)) {
                    this.bNodeMap.put(resource, "b" + this.bNodeCounter++);
                }
                label = (String)this.bNodeMap.get(resource);
            }
            jsonValue.put("type", "bnode");
            jsonValue.put("value", label);
        } else {
            jsonValue.put("type", "uri");
            jsonValue.put("value", resource.getURI());
        }
        return jsonValue;
    }

    private JSONObject literalAsJSON(Literal literal) throws JSONException {
        JSONObject jsonValue = new JSONObject();
        String datatype = literal.getDatatypeURI();
        String lang = literal.getLanguage();
        if (datatype != null && !datatype.equals("")) {
            jsonValue.put("type", "typed-literal");
            jsonValue.put("datatype", datatype);
        } else {
            jsonValue.put("type", "literal");
        }
        if (lang != null && lang.length() != 0) {
            jsonValue.put("xml:lang", lang);
        }
        jsonValue.put("value", literal.getLexicalForm());
        return jsonValue;
    }
}

