/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.AugmentedSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Err;
import net.sf.saxon.JavaPlatform;
import net.sf.saxon.NonDelegatingURIResolver;
import net.sf.saxon.Platform;
import net.sf.saxon.event.IDFilter;
import net.sf.saxon.functions.URIQueryParameters;
import net.sf.saxon.om.AllElementStripper;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class StandardURIResolver
implements NonDelegatingURIResolver,
Serializable {
    private Configuration config = null;
    protected boolean recognizeQueryParameters = false;

    public StandardURIResolver() {
        this(null);
    }

    public StandardURIResolver(Configuration configuration) {
        this.config = configuration;
    }

    public void setRecognizeQueryParameters(boolean bl) {
        this.recognizeQueryParameters = bl;
    }

    public boolean queryParametersAreRecognized() {
        return this.recognizeQueryParameters;
    }

    protected Platform getPlatform() {
        if (this.config == null) {
            return JavaPlatform.getInstance();
        }
        return this.config.getPlatform();
    }

    public Source resolve(String string, String string2) throws XPathException {
        Integer n;
        URI uRI;
        Platform platform = this.getPlatform();
        String string3 = string;
        String string4 = null;
        int n2 = string.indexOf(35);
        if (n2 >= 0) {
            string3 = string.substring(0, n2);
            string4 = string.substring(n2 + 1);
        }
        URIQueryParameters uRIQueryParameters = null;
        try {
            string3 = JavaPlatform.escapeSpaces(string3);
            uRI = new URI(string3);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new DynamicError("Invalid relative URI " + Err.wrap(string3), uRISyntaxException);
        }
        String string5 = uRI.getQuery();
        if (string5 != null && this.recognizeQueryParameters) {
            uRIQueryParameters = new URIQueryParameters(string5, this.config);
            int n4 = string3.indexOf(63);
            string3 = string3.substring(0, n4);
        }
        Source source = null;
        if (this.recognizeQueryParameters && string3.endsWith(".ptree")) {
            source = this.getPTreeSource(string3, string2);
        }
        if (source == null) {
            XMLReader xMLReader;
            URI uRI2;
            try {
                uRI2 = platform.makeAbsolute(string3, string2);
            }
            catch (URISyntaxException uRISyntaxException) {
                String string6 = JavaPlatform.tryToExpand(string2);
                if (!string6.equals(string2)) {
                    return this.resolve(string, string6);
                }
                throw new DynamicError("Invalid URI " + Err.wrap(string3) + " - base " + Err.wrap(string2), uRISyntaxException);
            }
            source = new SAXSource();
            ((SAXSource)source).setInputSource(new InputSource(uRI2.toString()));
            source.setSystemId(uRI2.toString());
            if (uRIQueryParameters != null && (xMLReader = uRIQueryParameters.getXMLReader()) != null) {
                ((SAXSource)source).setXMLReader(xMLReader);
            }
            if (((SAXSource)source).getXMLReader() == null && this.config == null) {
                try {
                    ((SAXSource)source).setXMLReader(SAXParserFactory.newInstance().newSAXParser().getXMLReader());
                }
                catch (Exception exception) {
                    throw new DynamicError(exception);
                }
            }
        }
        if (uRIQueryParameters != null) {
            int n5 = uRIQueryParameters.getStripSpace();
            switch (n5) {
                case 12: {
                    AllElementStripper allElementStripper = AllElementStripper.getInstance();
                    allElementStripper.setStripAll();
                    source = AugmentedSource.makeAugmentedSource(source);
                    ((AugmentedSource)source).addFilter(allElementStripper);
                    break;
                }
                case 10: 
                case 11: {
                    source = AugmentedSource.makeAugmentedSource(source);
                    ((AugmentedSource)source).setStripSpace(n5);
                }
            }
        }
        if (string4 != null) {
            IDFilter iDFilter = new IDFilter(string4);
            source = AugmentedSource.makeAugmentedSource(source);
            ((AugmentedSource)source).addFilter(iDFilter);
        }
        if (uRIQueryParameters != null && (n = uRIQueryParameters.getValidationMode()) != null) {
            source = AugmentedSource.makeAugmentedSource(source);
            ((AugmentedSource)source).setSchemaValidationMode(n);
        }
        return source;
    }

    protected Source getPTreeSource(String string, String string2) throws XPathException {
        return null;
    }
}

