/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.Procedure;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.instruct.TailCallReturner;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trace.InstructionInfoProvider;
import net.sf.saxon.trans.XPathException;

public class Template
extends Procedure
implements InstructionInfoProvider {
    private int precedence;
    private int minImportPrecedence;
    private int templateFingerprint;
    private transient InstructionDetails details;

    public Template() {
        this.setHostLanguage(50);
    }

    public void init(int n, int n2, int n4) {
        this.templateFingerprint = n;
        this.precedence = n2;
        this.minImportPrecedence = n4;
    }

    public int getFingerprint() {
        return this.templateFingerprint;
    }

    public int getPrecedence() {
        return this.precedence;
    }

    public int getMinImportPrecedence() {
        return this.minImportPrecedence;
    }

    public void process(XPathContext xPathContext) throws XPathException {
        for (TailCall tailCall = this.processLeavingTail(xPathContext); tailCall != null; tailCall = tailCall.processLeavingTail()) {
        }
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        if (this.getBody() == null) {
            return null;
        }
        XPathContextMajor xPathContextMajor = xPathContext.newContext();
        xPathContextMajor.setOrigin(this);
        xPathContextMajor.setCurrentTemplate(this);
        TailCall tailCall = this.expand(xPathContextMajor);
        return tailCall;
    }

    public TailCall expand(XPathContext xPathContext) throws XPathException {
        Expression expression = this.getBody();
        if (expression == null) {
            return null;
        }
        if (expression instanceof TailCallReturner) {
            return ((TailCallReturner)((Object)expression)).processLeavingTail(xPathContext);
        }
        expression.process(xPathContext);
        return null;
    }

    public InstructionInfo getInstructionInfo() {
        if (this.details == null) {
            this.details = new InstructionDetails();
            this.details.setSystemId(this.getSystemId());
            this.details.setLineNumber(this.getLineNumber());
            this.details.setConstructType(181);
            this.details.setProperty("template", this);
        }
        return this.details;
    }

    public boolean hasBadParentPointer() {
        return ((ComputedExpression)this.getBody()).hasBadParentPointer();
    }
}

