/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Sender;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.Aggregate;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.ExternalObjectModel;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.om.VirtualNode;
import net.sf.saxon.tinytree.TinyBuilder;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInSchemaFactory;
import net.sf.saxon.type.ExternalObjectType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Closure;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.HexBinaryValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.SingletonNode;
import net.sf.saxon.value.StringValue;

public abstract class Value
implements Expression,
Serializable,
ValueRepresentation {
    public static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$net$sf$saxon$om$SequenceIterator;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$ArrayList;
    static /* synthetic */ Class class$net$sf$saxon$om$Item;
    static /* synthetic */ Class class$net$sf$saxon$om$NodeInfo;
    static /* synthetic */ Class class$net$sf$saxon$om$DocumentInfo;

    public static Value asValue(ValueRepresentation valueRepresentation) {
        if (valueRepresentation instanceof Value) {
            return (Value)valueRepresentation;
        }
        if (valueRepresentation == null) {
            return EmptySequence.getInstance();
        }
        return new SingletonNode((NodeInfo)valueRepresentation);
    }

    public static Item asItem(ValueRepresentation valueRepresentation) throws XPathException {
        if (valueRepresentation instanceof Item) {
            return (Item)valueRepresentation;
        }
        if (valueRepresentation instanceof EmptySequence) {
            return null;
        }
        if (valueRepresentation instanceof SingletonNode) {
            return ((SingletonNode)valueRepresentation).getNode();
        }
        if (valueRepresentation instanceof AtomicValue) {
            return (AtomicValue)valueRepresentation;
        }
        SequenceIterator sequenceIterator = Value.getIterator(valueRepresentation);
        Item item = sequenceIterator.next();
        if (item == null) {
            return null;
        }
        if (sequenceIterator.next() != null) {
            throw new AssertionError((Object)"Attempting to access a sequence as an item");
        }
        return item;
    }

    public static SequenceIterator asIterator(ValueRepresentation valueRepresentation, XPathContext xPathContext) throws XPathException {
        if (valueRepresentation instanceof Value) {
            return ((Value)valueRepresentation).iterate(xPathContext);
        }
        if (valueRepresentation == null) {
            return EmptyIterator.getInstance();
        }
        return SingletonIterator.makeIterator((NodeInfo)valueRepresentation);
    }

    public static double stringToNumber(CharSequence charSequence) throws NumberFormatException {
        String string = ((Object)Value.trimWhitespace(charSequence)).toString();
        if ("INF".equals(string)) {
            return Double.POSITIVE_INFINITY;
        }
        if ("-INF".equals(string)) {
            return Double.NEGATIVE_INFINITY;
        }
        if ("NaN".equals(string)) {
            return Double.NaN;
        }
        return Double.parseDouble(string);
    }

    public static CharSequence normalizeWhitespace(CharSequence charSequence) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(charSequence.length());
        block3: for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': {
                    fastStringBuffer.append(' ');
                    continue block3;
                }
                default: {
                    fastStringBuffer.append(c);
                }
            }
        }
        return fastStringBuffer;
    }

    public static CharSequence collapseWhitespace(CharSequence charSequence) {
        int n;
        int n2 = charSequence.length();
        if (n2 == 0) {
            return charSequence;
        }
        FastStringBuffer fastStringBuffer = new FastStringBuffer(n2);
        boolean bl = true;
        block3: for (int i = 0; i < n2; ++i) {
            n = charSequence.charAt(i);
            switch (n) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    if (bl) continue block3;
                    fastStringBuffer.append(' ');
                    bl = true;
                    continue block3;
                }
                default: {
                    fastStringBuffer.append((char)n);
                    bl = false;
                }
            }
        }
        n = fastStringBuffer.length();
        if (n > 0 && fastStringBuffer.charAt(n - '\u0001') == ' ') {
            fastStringBuffer.setLength(n - '\u0001');
        }
        return fastStringBuffer;
    }

    public static CharSequence trimWhitespace(CharSequence charSequence) {
        if (charSequence.length() == 0) {
            return charSequence;
        }
        int n = 0;
        int n2 = charSequence.length() - 1;
        while (charSequence.charAt(n) <= ' ') {
            if (n++ < n2) continue;
            return "";
        }
        while (charSequence.charAt(n2) <= ' ') {
            --n2;
        }
        return charSequence.subSequence(n, n2 + 1);
    }

    public static SequenceIterator getIterator(ValueRepresentation valueRepresentation) throws XPathException {
        if (valueRepresentation instanceof Value) {
            return ((Value)valueRepresentation).iterate(null);
        }
        if (valueRepresentation instanceof NodeInfo) {
            return SingletonIterator.makeIterator((NodeInfo)valueRepresentation);
        }
        if (valueRepresentation == null) {
            throw new AssertionError((Object)"Value of variable is undefined (null)");
        }
        throw new AssertionError((Object)("Unknown value representation " + valueRepresentation.getClass()));
    }

    public final Expression simplify(StaticContext staticContext) {
        return this;
    }

    public final Expression typeCheck(StaticContext staticContext, ItemType itemType) {
        return this;
    }

    public final Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) {
        return this;
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return AnyItemType.getInstance();
    }

    public int getCardinality() {
        try {
            SequenceIterator sequenceIterator = this.iterate(null);
            Item item = sequenceIterator.next();
            if (item == null) {
                return 8192;
            }
            if (sequenceIterator.next() != null) {
                return 49152;
            }
            return 16384;
        }
        catch (XPathException xPathException) {
            return 57344;
        }
    }

    public final Iterator iterateSubExpressions() {
        return Collections.EMPTY_LIST.iterator();
    }

    public final Container getParentExpression() {
        return null;
    }

    public int getSpecialProperties() {
        return 0x400000;
    }

    public final Expression promote(PromotionOffer promotionOffer) {
        return this;
    }

    public final int getDependencies() {
        return 0;
    }

    public Item itemAt(int n) throws XPathException {
        Item item;
        if ((this.getImplementationMethod() & 1) != 0) {
            if (n == 0) {
                Item item2 = this.evaluateItem(null);
                return item2 == null ? null : item2;
            }
            return null;
        }
        if (n < 0) {
            return null;
        }
        int n2 = 0;
        SequenceIterator sequenceIterator = this.iterate(null);
        do {
            if ((item = sequenceIterator.next()) != null) continue;
            return null;
        } while (n2++ != n);
        return item;
    }

    public int getLength() throws XPathException {
        return Aggregate.count(this.iterate(null));
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        return this.iterate(xPathContext).next();
    }

    public void process(XPathContext xPathContext) throws XPathException {
        Item item;
        SequenceIterator sequenceIterator = this.iterate(xPathContext);
        SequenceReceiver sequenceReceiver = xPathContext.getReceiver();
        while ((item = sequenceIterator.next()) != null) {
            sequenceReceiver.append(item, 0, 2);
        }
    }

    public String getStringValue() throws XPathException {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(1024);
        SequenceIterator sequenceIterator = this.iterate(null);
        Item item = sequenceIterator.next();
        if (item != null) {
            while (true) {
                fastStringBuffer.append(item.getStringValueCS());
                item = sequenceIterator.next();
                if (item == null) break;
                fastStringBuffer.append(' ');
            }
        }
        return fastStringBuffer.toString();
    }

    public String evaluateAsString(XPathContext xPathContext) throws XPathException {
        AtomicValue atomicValue = (AtomicValue)this.evaluateItem(xPathContext);
        if (atomicValue == null) {
            return "";
        }
        return atomicValue.getStringValue();
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        return ExpressionTool.effectiveBooleanValue(this.iterate(xPathContext));
    }

    public boolean equals(Object object) {
        try {
            if (object instanceof Value) {
                Item item;
                Item item2;
                SequenceIterator sequenceIterator = this.iterate(null);
                SequenceIterator sequenceIterator2 = ((Value)object).iterate(null);
                do {
                    item2 = sequenceIterator.next();
                    item = sequenceIterator2.next();
                    if (item2 == null && item == null) {
                        return true;
                    }
                    if (item2 == null || item == null) {
                        return false;
                    }
                    if (!(item2 instanceof NodeInfo) && !(item instanceof NodeInfo)) continue;
                    return false;
                } while (item2.equals(item));
                return false;
            }
            return false;
        }
        catch (XPathException xPathException) {
            return false;
        }
    }

    public boolean schemaEquals(Value value) {
        try {
            Item item;
            Item item2;
            SequenceIterator sequenceIterator = this.iterate(null);
            SequenceIterator sequenceIterator2 = value.iterate(null);
            do {
                item2 = sequenceIterator.next();
                item = sequenceIterator2.next();
                if (item2 == null && item == null) {
                    return true;
                }
                if (item2 == null || item == null) {
                    return false;
                }
                if (!(item2 instanceof NodeInfo) && !(item instanceof NodeInfo)) continue;
                return false;
            } while (((AtomicValue)item2).schemaEquals((AtomicValue)item));
            return false;
        }
        catch (XPathException xPathException) {
            return false;
        }
    }

    public int hashCode() {
        try {
            int n = 107189858;
            SequenceIterator sequenceIterator = this.iterate(null);
            while (true) {
                Item item;
                if ((item = sequenceIterator.next()) == null) {
                    return n;
                }
                n ^= item.hashCode();
            }
        }
        catch (XPathException xPathException) {
            return 0;
        }
    }

    public void checkPermittedContents(SchemaType schemaType, StaticContext staticContext, boolean bl) throws XPathException {
    }

    public Value reduce() throws XPathException {
        return this;
    }

    public Object convertToJava(Class clazz, XPathContext xPathContext) throws XPathException {
        Object object;
        Object object2;
        Class<?> clazz2;
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = Value.class$("java.lang.Object")) : class$java$lang$Object)) {
            ArrayList arrayList = new ArrayList(20);
            return this.convertToJavaList(arrayList, xPathContext);
        }
        if (clazz.isAssignableFrom(this.getClass())) {
            return this;
        }
        if (clazz.isAssignableFrom(class$net$sf$saxon$om$SequenceIterator == null ? (class$net$sf$saxon$om$SequenceIterator = Value.class$("net.sf.saxon.om.SequenceIterator")) : class$net$sf$saxon$om$SequenceIterator)) {
            return this.iterate(xPathContext);
        }
        if (!(!(this instanceof ObjectValue) && this instanceof AtomicValue || this instanceof EmptySequence)) {
            clazz2 = xPathContext.getConfiguration().getExternalObjectModels();
            for (int i = 0; i < clazz2.size(); ++i) {
                object2 = (ExternalObjectModel)clazz2.get(i);
                object = object2.convertXPathValueToObject(this, clazz, xPathContext);
                if (object == null) continue;
                return object;
            }
        }
        if ((class$java$util$Collection == null ? (class$java$util$Collection = Value.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(clazz)) {
            if (clazz.isAssignableFrom(class$java$util$ArrayList == null ? (class$java$util$ArrayList = Value.class$("java.util.ArrayList")) : class$java$util$ArrayList)) {
                clazz2 = new ArrayList(100);
            } else {
                try {
                    clazz2 = (Collection)clazz.newInstance();
                }
                catch (InstantiationException instantiationException) {
                    object2 = new DynamicError("Cannot instantiate collection class " + clazz);
                    ((DynamicError)object2).setXPathContext(xPathContext);
                    throw object2;
                }
                catch (IllegalAccessException illegalAccessException) {
                    object2 = new DynamicError("Cannot access collection class " + clazz);
                    ((DynamicError)object2).setXPathContext(xPathContext);
                    throw object2;
                }
            }
            return this.convertToJavaList((Collection)((Object)clazz2), xPathContext);
        }
        if (clazz.isArray()) {
            int n;
            clazz2 = clazz.getComponentType();
            if (clazz2.isAssignableFrom(class$net$sf$saxon$om$Item == null ? (class$net$sf$saxon$om$Item = Value.class$("net.sf.saxon.om.Item")) : class$net$sf$saxon$om$Item) || clazz2.isAssignableFrom(class$net$sf$saxon$om$NodeInfo == null ? (class$net$sf$saxon$om$NodeInfo = Value.class$("net.sf.saxon.om.NodeInfo")) : class$net$sf$saxon$om$NodeInfo) || clazz2.isAssignableFrom(class$net$sf$saxon$om$DocumentInfo == null ? (class$net$sf$saxon$om$DocumentInfo = Value.class$("net.sf.saxon.om.DocumentInfo")) : class$net$sf$saxon$om$DocumentInfo)) {
                Value value = this;
                if (value instanceof Closure) {
                    value = SequenceExtent.makeSequenceExtent(value.iterate(null));
                }
                int n2 = value.getLength();
                object = Array.newInstance(clazz2, n2);
                SequenceIterator sequenceIterator = value.iterate(null);
                for (int i = 0; i < n2; ++i) {
                    Item item = sequenceIterator.next();
                    try {
                        Array.set(object, i, item);
                        continue;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        DynamicError dynamicError = new DynamicError("Item " + i + " in supplied sequence cannot be converted " + "to the component type of the Java array (" + clazz2 + ')', illegalArgumentException);
                        dynamicError.setXPathContext(xPathContext);
                        throw dynamicError;
                    }
                }
                return object;
            }
            SequenceIterator sequenceIterator = Atomizer.AtomizingFunction.getAtomizingIterator(this.iterate(xPathContext));
            if ((sequenceIterator.getProperties() & 2) == 0) {
                object = new SequenceExtent(sequenceIterator);
                n = ((SequenceExtent)object).getLength();
                sequenceIterator = ((SequenceExtent)object).iterate(xPathContext);
            } else {
                n = ((LastPositionFinder)sequenceIterator).getLastPosition();
            }
            object = Array.newInstance(clazz2, n);
            for (int i = 0; i < n; ++i) {
                Object object3;
                try {
                    AtomicValue atomicValue = (AtomicValue)sequenceIterator.next();
                    object3 = atomicValue.convertToJava(clazz2, xPathContext);
                    Array.set(object, i, object3);
                    continue;
                }
                catch (XPathException xPathException) {
                    object3 = new DynamicError("Cannot convert item in atomized sequence to the component type of the Java array", xPathException);
                    ((DynamicError)object3).setXPathContext(xPathContext);
                    throw object3;
                }
            }
            return object;
        }
        if (clazz.isAssignableFrom(class$net$sf$saxon$om$Item == null ? (class$net$sf$saxon$om$Item = Value.class$("net.sf.saxon.om.Item")) : class$net$sf$saxon$om$Item) || clazz.isAssignableFrom(class$net$sf$saxon$om$NodeInfo == null ? (class$net$sf$saxon$om$NodeInfo = Value.class$("net.sf.saxon.om.NodeInfo")) : class$net$sf$saxon$om$NodeInfo) || clazz.isAssignableFrom(class$net$sf$saxon$om$DocumentInfo == null ? (class$net$sf$saxon$om$DocumentInfo = Value.class$("net.sf.saxon.om.DocumentInfo")) : class$net$sf$saxon$om$DocumentInfo)) {
            clazz2 = this.iterate(null);
            Object object4 = null;
            while ((object2 = clazz2.next()) != null) {
                if (object4 != null) {
                    object = new DynamicError("Sequence contains more than one value; Java method expects only one");
                    ((DynamicError)object).setXPathContext(xPathContext);
                    throw object;
                }
                object4 = object2;
            }
            if (object4 == null) {
                return null;
            }
            if (clazz.isAssignableFrom(object4.getClass())) {
                return object4;
            }
            object2 = object4;
            while (object2 instanceof VirtualNode) {
                object = ((VirtualNode)object2).getUnderlyingNode();
                if (clazz.isAssignableFrom(object.getClass())) {
                    return object;
                }
                object2 = object;
            }
            throw new DynamicError("Cannot convert supplied XPath value to the required type for the extension function");
        }
        if (!(this instanceof AtomicValue)) {
            clazz2 = Atomizer.AtomizingFunction.getAtomizingIterator(this.iterate(xPathContext));
            Object object5 = null;
            while ((object2 = clazz2.next()) != null) {
                if (object5 != null) {
                    object = new DynamicError("Sequence contains more than one value; Java method expects only one");
                    ((DynamicError)object).setXPathContext(xPathContext);
                    throw object;
                }
                object5 = object2;
            }
            if (object5 == null) {
                return null;
            }
            if (clazz.isAssignableFrom(object5.getClass())) {
                return object5;
            }
            return ((AtomicValue)object5).convertToJava(clazz, xPathContext);
        }
        throw new DynamicError("Cannot convert supplied XPath value to the required type for the extension function");
    }

    private Collection convertToJavaList(Collection collection, XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.iterate(null);
        Item item;
        while ((item = sequenceIterator.next()) != null) {
            if (item instanceof AtomicValue) {
                collection.add(((AtomicValue)item).convertToJava(class$java$lang$Object == null ? Value.class$("java.lang.Object") : class$java$lang$Object, xPathContext));
                continue;
            }
            if (item instanceof VirtualNode) {
                collection.add(((VirtualNode)item).getUnderlyingNode());
                continue;
            }
            collection.add(item);
        }
        return collection;
    }

    public void display(int n, NamePool namePool, PrintStream printStream) {
        TypeHierarchy typeHierarchy = namePool.getTypeHierarchy();
        try {
            Item item;
            printStream.println(ExpressionTool.indent(n) + "sequence of " + this.getItemType(typeHierarchy).toString() + " (");
            SequenceIterator sequenceIterator = this.iterate(null);
            while ((item = sequenceIterator.next()) != null) {
                if (item instanceof NodeInfo) {
                    printStream.println(ExpressionTool.indent(n + 1) + "node " + Navigator.getPath((NodeInfo)item));
                    continue;
                }
                printStream.println(ExpressionTool.indent(n + 1) + item.toString());
            }
            printStream.println(ExpressionTool.indent(n) + ')');
        }
        catch (XPathException xPathException) {
            printStream.println(ExpressionTool.indent(n) + "(*error*)");
        }
    }

    public static Value convertJavaObjectToXPath(Object object, SequenceType sequenceType, Configuration configuration) throws XPathException {
        ItemType itemType = sequenceType.getPrimaryType();
        if (object == null) {
            return EmptySequence.getInstance();
        }
        List list = configuration.getExternalObjectModels();
        for (int i = 0; i < list.size(); ++i) {
            ExternalObjectModel externalObjectModel = (ExternalObjectModel)list.get(i);
            Value value = externalObjectModel.convertObjectToXPathValue(object, configuration);
            if (value == null || TypeChecker.testConformance(value, sequenceType, configuration) != null) continue;
            return value;
        }
        if (itemType instanceof ExternalObjectType) {
            Class clazz = ((ExternalObjectType)itemType).getJavaClass();
            if (clazz.isAssignableFrom(object.getClass())) {
                return new ObjectValue(object);
            }
            throw new DynamicError("Supplied parameter value is not of class " + clazz.getName());
        }
        Value value = Value.convertToBestFit(object, configuration);
        return value;
    }

    private static Value convertToBestFit(Object object, Configuration configuration) throws XPathException {
        if (object instanceof String) {
            return StringValue.makeStringValue((String)object);
        }
        if (object instanceof Character) {
            return new StringValue(object.toString());
        }
        if (object instanceof Boolean) {
            return BooleanValue.get((Boolean)object);
        }
        if (object instanceof Double) {
            return new DoubleValue((Double)object);
        }
        if (object instanceof Float) {
            return new FloatValue(((Float)object).floatValue());
        }
        if (object instanceof Short) {
            return new IntegerValue(((Short)object).shortValue(), (AtomicType)BuiltInSchemaFactory.getSchemaType(537));
        }
        if (object instanceof Integer) {
            return new IntegerValue(((Integer)object).intValue(), (AtomicType)BuiltInSchemaFactory.getSchemaType(536));
        }
        if (object instanceof Long) {
            return new IntegerValue((Long)object, (AtomicType)BuiltInSchemaFactory.getSchemaType(535));
        }
        if (object instanceof Byte) {
            return new IntegerValue(((Byte)object).byteValue(), (AtomicType)BuiltInSchemaFactory.getSchemaType(538));
        }
        if (object instanceof BigInteger) {
            return BigIntegerValue.makeValue((BigInteger)object);
        }
        if (object instanceof BigDecimal) {
            return new DecimalValue((BigDecimal)object);
        }
        if (object.getClass().getName().equals("javax.xml.namespace.QName")) {
            return Value.makeQNameValue(object, configuration);
        }
        if (object instanceof URI) {
            return new AnyURIValue(object.toString());
        }
        if (object instanceof URL) {
            return new AnyURIValue(object.toString());
        }
        if (object instanceof Closure) {
            return ExpressionTool.eagerEvaluate((Closure)object, configuration.getConversionContext());
        }
        if (object instanceof Value) {
            return (Value)object;
        }
        if (object instanceof NodeInfo) {
            if (((NodeInfo)object).getNamePool() != configuration.getNamePool()) {
                throw new DynamicError("Externally-supplied node belongs to wrong NamePool");
            }
            return new SingletonNode((NodeInfo)object);
        }
        if (object instanceof SequenceIterator) {
            return Closure.makeIteratorClosure((SequenceIterator)object);
        }
        if (object instanceof List) {
            Item[] itemArray = new Item[((List)object).size()];
            int n = 0;
            Iterator iterator = ((List)object).iterator();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                if (e2 instanceof NodeInfo) {
                    itemArray[n++] = (NodeInfo)e2;
                    continue;
                }
                Value value = Value.convertToBestFit(e2, configuration);
                if (value == null) continue;
                if (value instanceof Item) {
                    itemArray[n++] = (Item)((Object)value);
                    continue;
                }
                if (value instanceof EmptySequence) continue;
                if (value instanceof SingletonNode) {
                    NodeInfo nodeInfo = ((SingletonNode)value).getNode();
                    if (nodeInfo == null) continue;
                    itemArray[n++] = nodeInfo;
                    continue;
                }
                throw new DynamicError("Returned List contains an object that cannot be converted to an Item (" + e2.getClass() + ')');
            }
            return new SequenceExtent(itemArray);
        }
        if (object instanceof Object[]) {
            Item[] itemArray = new Item[((Object[])object).length];
            int n = 0;
            for (int i = 0; i < ((Object[])object).length; ++i) {
                Value value;
                Object object2 = ((Object[])object)[i];
                if (object2 instanceof NodeInfo) {
                    itemArray[n++] = (NodeInfo)object2;
                    continue;
                }
                if (object2 == null || (value = Value.convertToBestFit(object2, configuration)) == null) continue;
                if (value instanceof Item) {
                    itemArray[n++] = (Item)((Object)value);
                    continue;
                }
                throw new DynamicError("Returned array contains an object that cannot be converted to an Item (" + object2.getClass() + ')');
            }
            return new SequenceExtent(itemArray, 0, n);
        }
        if (object instanceof long[]) {
            Item[] itemArray = new Item[((long[])object).length];
            for (int i = 0; i < ((long[])object).length; ++i) {
                itemArray[i] = new IntegerValue(((long[])object)[i]);
            }
            return new SequenceExtent(itemArray);
        }
        if (object instanceof int[]) {
            Item[] itemArray = new Item[((int[])object).length];
            for (int i = 0; i < ((int[])object).length; ++i) {
                itemArray[i] = new IntegerValue(((int[])object)[i]);
            }
            return new SequenceExtent(itemArray);
        }
        if (object instanceof short[]) {
            Item[] itemArray = new Item[((short[])object).length];
            for (int i = 0; i < ((short[])object).length; ++i) {
                itemArray[i] = new IntegerValue(((short[])object)[i]);
            }
            return new SequenceExtent(itemArray);
        }
        if (object instanceof byte[]) {
            Item[] itemArray = new Item[((byte[])object).length];
            for (int i = 0; i < ((byte[])object).length; ++i) {
                itemArray[i] = new IntegerValue(0xFF & ((byte[])object)[i]);
            }
            return new SequenceExtent(itemArray);
        }
        if (object instanceof char[]) {
            return StringValue.makeStringValue(new String((char[])object));
        }
        if (object instanceof boolean[]) {
            Item[] itemArray = new Item[((boolean[])object).length];
            for (int i = 0; i < ((boolean[])object).length; ++i) {
                itemArray[i] = BooleanValue.get(((boolean[])object)[i]);
            }
            return new SequenceExtent(itemArray);
        }
        if (object instanceof Source && configuration != null) {
            if (object instanceof DOMSource) {
                return new SingletonNode(Controller.unravel((Source)object, configuration));
            }
            try {
                TinyBuilder tinyBuilder = new TinyBuilder();
                PipelineConfiguration pipelineConfiguration = configuration.makePipelineConfiguration();
                tinyBuilder.setPipelineConfiguration(pipelineConfiguration);
                new Sender(pipelineConfiguration).send((Source)object, tinyBuilder);
                return new SingletonNode(tinyBuilder.getCurrentRoot());
            }
            catch (XPathException xPathException) {
                throw new DynamicError(xPathException);
            }
        }
        ExternalObjectModel externalObjectModel = configuration.findExternalObjectModel(object);
        if (externalObjectModel != null) {
            DocumentInfo documentInfo = externalObjectModel.wrapDocument(object, "", configuration);
            NodeInfo nodeInfo = externalObjectModel.wrapNode(documentInfo, object);
            return Value.asValue(nodeInfo);
        }
        return new ObjectValue(object);
    }

    public static QNameValue makeQNameValue(Object object, Configuration configuration) {
        try {
            Class clazz = configuration.getClass("javax.xml.namespace.QName", false, null);
            Object[] objectArray = EMPTY_CLASS_ARRAY;
            Method method = clazz.getMethod("getPrefix", (Class<?>[])objectArray);
            Method method2 = clazz.getMethod("getLocalPart", (Class<?>[])objectArray);
            Method method3 = clazz.getMethod("getNamespaceURI", (Class<?>[])objectArray);
            String string = (String)method.invoke(object, objectArray);
            String string2 = (String)method2.invoke(object, objectArray);
            String string3 = (String)method3.invoke(object, objectArray);
            return new QNameValue(string, string3, string2, configuration.getNameChecker());
        }
        catch (XPathException xPathException) {
            return null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            return null;
        }
    }

    public String toString() {
        try {
            return this.getStringValue();
        }
        catch (XPathException xPathException) {
            return super.toString();
        }
    }

    public static Object convert(Item item) throws XPathException {
        if (item instanceof NodeInfo) {
            Object object = item;
            while (object instanceof VirtualNode) {
                object = ((VirtualNode)object).getUnderlyingNode();
            }
            return object;
        }
        switch (((AtomicValue)item).getItemType(null).getPrimitiveType()) {
            case 513: 
            case 518: 
            case 529: 
            case 642: {
                return item.getStringValue();
            }
            case 514: {
                return ((BooleanValue)item).getBooleanValue() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 515: {
                return ((DecimalValue)item).getValue();
            }
            case 532: {
                return new Long(((NumericValue)item).longValue());
            }
            case 517: {
                return new Double(((DoubleValue)item).getDoubleValue());
            }
            case 516: {
                return new Float(((FloatValue)item).getFloatValue());
            }
            case 519: {
                return ((DateTimeValue)item).getCalendar().getTime();
            }
            case 521: {
                return ((DateValue)item).getCalendar().getTime();
            }
            case 520: {
                return item.getStringValue();
            }
            case 528: {
                return ((Base64BinaryValue)item).getBinaryValue();
            }
            case 527: {
                return ((HexBinaryValue)item).getBinaryValue();
            }
        }
        return item;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

