/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.functions.NormalizeSpace;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.tinytree.CompressedWhitespace;

public class Whitespace {
    public static final int PRESERVE = 0;
    public static final int REPLACE = 1;
    public static final int COLLAPSE = 2;
    public static final int NONE = 10;
    public static final int IGNORABLE = 11;
    public static final int ALL = 12;
    public static final int UNSPECIFIED = 13;
    private static boolean[] C0WHITE = new boolean[]{false, false, false, false, false, false, false, false, false, true, true, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true};

    private Whitespace() {
    }

    public static boolean isWhitespace(int n) {
        switch (n) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    public static CharSequence applyWhitespaceNormalization(int n, CharSequence charSequence) {
        switch (n) {
            case 0: {
                return charSequence;
            }
            case 1: {
                FastStringBuffer fastStringBuffer = new FastStringBuffer(charSequence.length());
                for (int i = 0; i < charSequence.length(); ++i) {
                    char c = charSequence.charAt(i);
                    switch (c) {
                        case '\t': 
                        case '\n': 
                        case '\r': {
                            fastStringBuffer.append(' ');
                        }
                    }
                    fastStringBuffer.append(c);
                }
                return fastStringBuffer;
            }
            case 2: {
                return NormalizeSpace.normalize(charSequence);
            }
        }
        throw new IllegalArgumentException("Unknown whitespace facet value");
    }

    public static CharSequence removeAllWhitespace(CharSequence charSequence) {
        if (Whitespace.containsWhitespace(charSequence)) {
            FastStringBuffer fastStringBuffer = new FastStringBuffer(charSequence.length());
            for (int i = 0; i < charSequence.length(); ++i) {
                char c = charSequence.charAt(i);
                if (c <= ' ' && C0WHITE[c]) continue;
                fastStringBuffer.append(c);
            }
            return fastStringBuffer;
        }
        return charSequence;
    }

    public static CharSequence removeLeadingWhitespace(CharSequence charSequence) {
        int n = 0;
        int n2 = charSequence.length();
        for (int i = 0; i < n2; ++i) {
            char c = charSequence.charAt(i);
            if (c <= ' ' && C0WHITE[c]) continue;
            n = i;
            break;
        }
        if (n == 0) {
            return charSequence;
        }
        if (n == n2 - 1) {
            return "";
        }
        return charSequence.subSequence(n, n2);
    }

    public static boolean containsWhitespace(CharSequence charSequence) {
        int n = charSequence.length();
        int n2 = 0;
        while (n2 < n) {
            char c;
            if ((c = charSequence.charAt(n2++)) > ' ' || !C0WHITE[c]) continue;
            return true;
        }
        return false;
    }

    public static final boolean isWhite(CharSequence charSequence) {
        if (charSequence instanceof CompressedWhitespace) {
            return true;
        }
        int n = charSequence.length();
        int n2 = 0;
        while (n2 < n) {
            char c;
            if ((c = charSequence.charAt(n2++)) <= ' ' && C0WHITE[c]) continue;
            return false;
        }
        return true;
    }
}

