/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import org.apache.lucene.index.Payload;

public class Token
implements Cloneable {
    public static final String DEFAULT_TYPE = "word";
    private static int MIN_BUFFER_SIZE = 10;
    private String termText;
    char[] termBuffer;
    int termLength;
    int startOffset;
    int endOffset;
    String type = "word";
    Payload payload;
    int positionIncrement = 1;

    public Token() {
    }

    public Token(int start, int end) {
        this.startOffset = start;
        this.endOffset = end;
    }

    public Token(int start, int end, String typ) {
        this.startOffset = start;
        this.endOffset = end;
        this.type = typ;
    }

    public Token(String text, int start, int end) {
        this.termText = text;
        this.startOffset = start;
        this.endOffset = end;
    }

    public Token(String text, int start, int end, String typ) {
        this.termText = text;
        this.startOffset = start;
        this.endOffset = end;
        this.type = typ;
    }

    public void setPositionIncrement(int positionIncrement) {
        if (positionIncrement < 0) {
            throw new IllegalArgumentException("Increment must be zero or greater: " + positionIncrement);
        }
        this.positionIncrement = positionIncrement;
    }

    public int getPositionIncrement() {
        return this.positionIncrement;
    }

    public void setTermText(String text) {
        this.termText = text;
        this.termBuffer = null;
    }

    public final String termText() {
        if (this.termText == null && this.termBuffer != null) {
            this.termText = new String(this.termBuffer, 0, this.termLength);
        }
        return this.termText;
    }

    public final void setTermBuffer(char[] buffer, int offset, int length) {
        this.resizeTermBuffer(length);
        System.arraycopy(buffer, offset, this.termBuffer, 0, length);
        this.termLength = length;
    }

    public final char[] termBuffer() {
        this.initTermBuffer();
        return this.termBuffer;
    }

    public char[] resizeTermBuffer(int newSize) {
        this.initTermBuffer();
        if (newSize > this.termBuffer.length) {
            int size;
            for (size = this.termBuffer.length; size < newSize; size *= 2) {
            }
            char[] newBuffer = new char[size];
            System.arraycopy(this.termBuffer, 0, newBuffer, 0, this.termBuffer.length);
            this.termBuffer = newBuffer;
        }
        return this.termBuffer;
    }

    private void initTermBuffer() {
        if (this.termBuffer == null) {
            if (this.termText == null) {
                this.termBuffer = new char[MIN_BUFFER_SIZE];
                this.termLength = 0;
            } else {
                int length = this.termText.length();
                if (length < MIN_BUFFER_SIZE) {
                    length = MIN_BUFFER_SIZE;
                }
                this.termBuffer = new char[length];
                this.termLength = this.termText.length();
                this.termText.getChars(0, this.termText.length(), this.termBuffer, 0);
                this.termText = null;
            }
        } else if (this.termText != null) {
            this.termText = null;
        }
    }

    public final int termLength() {
        this.initTermBuffer();
        return this.termLength;
    }

    public final void setTermLength(int length) {
        this.initTermBuffer();
        this.termLength = length;
    }

    public final int startOffset() {
        return this.startOffset;
    }

    public void setStartOffset(int offset) {
        this.startOffset = offset;
    }

    public final int endOffset() {
        return this.endOffset;
    }

    public void setEndOffset(int offset) {
        this.endOffset = offset;
    }

    public final String type() {
        return this.type;
    }

    public final void setType(String type) {
        this.type = type;
    }

    public Payload getPayload() {
        return this.payload;
    }

    public void setPayload(Payload payload) {
        this.payload = payload;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('(');
        this.initTermBuffer();
        if (this.termBuffer == null) {
            sb.append("null");
        } else {
            sb.append(this.termBuffer, 0, this.termLength);
        }
        sb.append(',').append(this.startOffset).append(',').append(this.endOffset);
        if (!this.type.equals(DEFAULT_TYPE)) {
            sb.append(",type=").append(this.type);
        }
        if (this.positionIncrement != 1) {
            sb.append(",posIncr=").append(this.positionIncrement);
        }
        sb.append(')');
        return sb.toString();
    }

    public void clear() {
        this.payload = null;
        this.termLength = 0;
        this.termText = null;
        this.positionIncrement = 1;
    }

    public Object clone() {
        try {
            Token t = (Token)super.clone();
            if (this.termBuffer != null) {
                t.termBuffer = null;
                t.setTermBuffer(this.termBuffer, 0, this.termLength);
            }
            if (this.payload != null) {
                t.setPayload((Payload)this.payload.clone());
            }
            return t;
        }
        catch (CloneNotSupportedException e2) {
            throw new RuntimeException(e2);
        }
    }
}

