/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.function;

import org.apache.lucene.search.Explanation;

public abstract class DocValues {
    private float minVal;
    private float maxVal;
    private float avgVal;
    private boolean computed = false;

    public abstract float floatVal(int var1);

    public int intVal(int doc) {
        return (int)this.floatVal(doc);
    }

    public long longVal(int doc) {
        return (long)this.floatVal(doc);
    }

    public double doubleVal(int doc) {
        return this.floatVal(doc);
    }

    public String strVal(int doc) {
        return Float.toString(this.floatVal(doc));
    }

    public abstract String toString(int var1);

    public Explanation explain(int doc) {
        return new Explanation(this.floatVal(doc), this.toString(doc));
    }

    Object getInnerArray() {
        throw new UnsupportedOperationException("this optional method is for test purposes only");
    }

    private void compute() {
        if (this.computed) {
            return;
        }
        this.minVal = Float.MAX_VALUE;
        this.maxVal = 0.0f;
        float sum = 0.0f;
        int n = 0;
        while (true) {
            float val;
            try {
                val = this.floatVal(n);
            }
            catch (ArrayIndexOutOfBoundsException e2) {
                break;
            }
            sum += val;
            this.minVal = Math.min(this.minVal, val);
            this.maxVal = Math.max(this.maxVal, val);
        }
        this.avgVal = sum / (float)n;
        this.computed = true;
    }

    public float getMinValue() {
        this.compute();
        return this.minVal;
    }

    public float getMaxValue() {
        this.compute();
        return this.maxVal;
    }

    public float getAverageValue() {
        this.compute();
        return this.avgVal;
    }
}

