/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.controller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.controller.EditorMap;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.controller.Traverser;
import org.biopax.paxtools.controller.Visitor;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.util.Filter;

public class Merger
implements Visitor {
    private static final Log log = LogFactory.getLog(Merger.class);
    private final Traverser traverser;
    private final HashMap<Integer, List<BioPAXElement>> equivalenceMap = new HashMap();
    private final EditorMap map;
    private final HashSet<BioPAXElement> mergedElements = new HashSet();
    private final HashSet<BioPAXElement> addedElements = new HashSet();

    public Merger(EditorMap map) {
        this.map = map;
        this.traverser = new Traverser(map, this, new Filter[0]);
    }

    public void visit(BioPAXElement domain, Object range, Model model, PropertyEditor editor) {
        BioPAXElement bpe;
        if (range != null && range instanceof BioPAXElement && !model.contains(bpe = (BioPAXElement)range) && model.getByID(bpe.getRDFId()) != null) {
            if (editor.isMultipleCardinality()) {
                editor.removeValueFromBean(bpe, domain);
            }
            editor.setValueToBean(this.getIdentical(bpe), domain);
        }
    }

    public HashSet<BioPAXElement> getMergedElements() {
        return this.mergedElements;
    }

    public HashSet<BioPAXElement> getAddedElements() {
        return this.addedElements;
    }

    public void merge(Model target, Model ... sources) {
        this.mergedElements.clear();
        this.addedElements.clear();
        Set<BioPAXElement> targetElements = target.getObjects();
        for (BioPAXElement t_bpe : targetElements) {
            this.addIntoEquivalanceMap(t_bpe);
        }
        for (Model source : sources) {
            Set<BioPAXElement> sourceElements = source.getObjects();
            for (BioPAXElement bpe : sourceElements) {
                this.insert(target, bpe);
            }
        }
    }

    private void insert(Model target, BioPAXElement bpe) {
        if (!target.contains(bpe)) {
            BioPAXElement ibpe = target.getByID(bpe.getRDFId());
            if (ibpe != null && ibpe.equals(bpe)) {
                this.updateObjectFields(bpe, ibpe, target);
                this.mergedElements.add(ibpe);
            } else {
                target.add(bpe);
                this.addIntoEquivalanceMap(bpe);
                this.traverser.traverse(bpe, target);
                this.addedElements.add(bpe);
            }
        }
    }

    private BioPAXElement getIdentical(BioPAXElement bpe) {
        int key = bpe.hashCode();
        List<BioPAXElement> list = this.equivalenceMap.get(key);
        if (list != null) {
            for (BioPAXElement other : list) {
                if (!other.equals(bpe)) continue;
                return other;
            }
        }
        return null;
    }

    private void updateObjectFields(BioPAXElement update, BioPAXElement existing, Model target) {
        Set<PropertyEditor> editors = this.map.getEditorsOf(update);
        for (PropertyEditor editor : editors) {
            this.updateObjectFieldsForEditor(editor, update, existing, target);
        }
    }

    private void updateObjectFieldsForEditor(PropertyEditor editor, BioPAXElement update, BioPAXElement existing, Model target) {
        if (editor.isMultipleCardinality()) {
            for (Object updateValue : editor.getValueFromBean(update)) {
                this.updateField(editor, updateValue, existing, target);
            }
        } else {
            Set existingValue = editor.getValueFromBean(existing);
            Set updateValue = editor.getValueFromBean(update);
            if (editor.isUnknown(existingValue)) {
                if (!editor.isUnknown(updateValue)) {
                    this.updateField(editor, updateValue, existing, target);
                }
            } else if (!((Object)existingValue).equals(updateValue)) {
                log.warn("Mismatch in single cardinality field:" + existingValue + ":" + updateValue);
                log.warn("Using existing value");
            }
        }
    }

    private void updateField(PropertyEditor editor, Object updateValue, BioPAXElement existing, Model target) {
        BioPAXElement bpe;
        BioPAXElement ibpe;
        if (updateValue instanceof BioPAXElement && (ibpe = target.getByID((bpe = (BioPAXElement)updateValue).getRDFId())) != null) {
            updateValue = ibpe;
        }
        editor.setValueToBean(updateValue, existing);
    }

    private void addIntoEquivalanceMap(BioPAXElement bpe) {
        int key = bpe.hashCode();
        List<BioPAXElement> list = this.equivalenceMap.get(key);
        if (list == null) {
            list = new ArrayList<BioPAXElement>();
            this.equivalenceMap.put(key, list);
        }
        list.add(bpe);
    }
}

