/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.controller;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.controller.AbstractPropertyEditor;
import org.biopax.paxtools.controller.PropertyAccessor;
import org.biopax.paxtools.controller.SimplePropertyAccessor;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.util.AutoComplete;
import org.biopax.paxtools.util.IllegalBioPAXArgumentException;

public class ObjectPropertyEditor<D extends BioPAXElement, R extends BioPAXElement>
extends AbstractPropertyEditor<D, R> {
    private Map<Class<? extends BioPAXElement>, Set<Class<? extends BioPAXElement>>> restrictedRanges = new HashMap<Class<? extends BioPAXElement>, Set<Class<? extends BioPAXElement>>>();
    private Method inverseGetMethod = this.findInverseGetMethod();
    private boolean inverseMultipleCardinality;
    private boolean completeForward;
    private boolean completeBackward;
    private PropertyAccessor<R, ? super D> inverseAccessor;

    public ObjectPropertyEditor(String property, Method getMethod, Class<D> domain, Class<R> range, boolean multipleCardinality) {
        super(property, getMethod, domain, range, multipleCardinality);
        AutoComplete autComp;
        if (this.inverseGetMethod != null) {
            this.inverseMultipleCardinality = ObjectPropertyEditor.isMultipleCardinality(this.inverseGetMethod);
            this.inverseAccessor = this.buildInverse(ObjectPropertyEditor.detectRange(this.inverseGetMethod), range);
        }
        if ((autComp = this.getGetMethod().getAnnotation(AutoComplete.class)) == null) {
            this.completeForward = true;
            this.completeBackward = false;
        } else {
            this.completeForward = autComp.forward();
            this.completeBackward = autComp.backward();
        }
    }

    private <T extends BioPAXElement> SimplePropertyAccessor<R, ? super D> buildInverse(Class<T> inverseRange, Class<R> inverseDomain) {
        return new SimplePropertyAccessor<R, T>(inverseDomain, inverseRange, this.inverseMultipleCardinality, this.inverseGetMethod);
    }

    public Map<Class<? extends BioPAXElement>, Set<Class<? extends BioPAXElement>>> getRestrictedRanges() {
        return this.restrictedRanges;
    }

    public boolean isCompleteForward() {
        return this.completeForward;
    }

    public boolean isCompleteBackward() {
        return this.completeBackward;
    }

    public boolean isInverseMultipleCardinality() {
        return this.inverseMultipleCardinality;
    }

    public Method getInverseGetMethod() {
        return this.inverseGetMethod;
    }

    public PropertyAccessor<R, ? super D> getInverseAccessor() {
        return this.inverseAccessor;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        for (Class<? extends BioPAXElement> rDomain : this.restrictedRanges.keySet()) {
            sb.append(" D:").append(rDomain.getSimpleName()).append("=");
            String delim = "";
            for (Class<? extends BioPAXElement> range : this.restrictedRanges.get(rDomain)) {
                sb.append(delim).append(range.getSimpleName());
                delim = ",";
            }
        }
        return sb.toString();
    }

    public void addRangeRestriction(Class<? extends BioPAXElement> domain, Set<Class<? extends BioPAXElement>> ranges) {
        this.restrictedRanges.put(domain, ranges);
    }

    public void setRangeRestriction(Map<Class<? extends BioPAXElement>, Set<Class<? extends BioPAXElement>>> restrictedRanges) {
        this.restrictedRanges = restrictedRanges;
    }

    @Override
    protected void checkRestrictions(R value, D bean) {
        super.checkRestrictions(value, bean);
        Set<Class<? extends BioPAXElement>> classes = this.getRestrictedRangesFor(bean.getModelInterface());
        if (classes != null && !this.isInstanceOfAtLeastOne(classes, value)) {
            throw new IllegalBioPAXArgumentException("The range restriction is violated; property: " + this.property + ", bean: " + bean + "--> value: " + value);
        }
    }

    public Set<Class<? extends BioPAXElement>> getRestrictedRangesFor(Class<? extends D> restrictedDomain) {
        Set<Class<? extends BioPAXElement>> classes = this.restrictedRanges.get(restrictedDomain);
        if (classes == null) {
            classes = new HashSet<Class<? extends BioPAXElement>>();
            classes.add(this.getRange());
        }
        return classes;
    }

    public boolean hasInverseLink() {
        return this.getInverseGetMethod() != null;
    }

    protected Method findInverseGetMethod() {
        String name = this.getGetMethod().getName() + "Of";
        Method method = null;
        try {
            method = this.getRange().getMethod(name, new Class[0]);
        }
        catch (NoSuchMethodException e2) {
            log.debug("Range " + this.getRange() + " has no inverse method named " + name);
        }
        return method;
    }
}

