/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.controller;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.biopax.paxtools.controller.PropertyAccessor;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.util.IllegalBioPAXArgumentException;

public abstract class PropertyAccessorAdapter<D extends BioPAXElement, R>
implements PropertyAccessor<D, R> {
    protected Class<D> domain;
    protected Class<R> range;
    protected boolean multipleCardinality;

    protected PropertyAccessorAdapter(Class<D> domain, Class<R> range, boolean multipleCardinality) {
        this.domain = domain;
        this.range = range;
        this.multipleCardinality = multipleCardinality;
    }

    @Override
    public Class<D> getDomain() {
        return this.domain;
    }

    @Override
    public Class<R> getRange() {
        return this.range;
    }

    @Override
    public boolean isMultipleCardinality() {
        return this.multipleCardinality;
    }

    @Override
    public Set<? extends R> getValueFromBeans(Collection<? extends D> beans) throws IllegalBioPAXArgumentException {
        HashSet aggregate = new HashSet();
        for (BioPAXElement bean : beans) {
            aggregate.addAll(this.getValueFromBean(bean));
        }
        return aggregate;
    }
}

