/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.controller;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.controller.EditorMap;
import org.biopax.paxtools.controller.Fetcher;
import org.biopax.paxtools.controller.ObjectPropertyEditor;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.util.Filter;

public class SimpleMerger {
    private static final Log LOG = LogFactory.getLog(SimpleMerger.class);
    private final EditorMap map;
    private Filter<BioPAXElement> mergeObjPropOf;

    public SimpleMerger(EditorMap map) {
        this.map = map;
    }

    public SimpleMerger(EditorMap map, Filter<BioPAXElement> mergeObjPropOf) {
        this(map);
        this.mergeObjPropOf = mergeObjPropOf;
    }

    public void merge(Model target, Model ... sources) {
        for (Model source : sources) {
            if (source == null) continue;
            this.merge(target, source.getObjects());
        }
    }

    public void merge(Model target, Collection<? extends BioPAXElement> elements) {
        Fetcher fetcher = new Fetcher(this.map, new Filter[0]);
        HashSet<? extends BioPAXElement> sources = new HashSet<BioPAXElement>(elements);
        for (BioPAXElement bioPAXElement : elements) {
            sources.addAll(fetcher.fetch(bioPAXElement));
        }
        for (BioPAXElement bioPAXElement : sources) {
            if (target.containsID(bioPAXElement.getRDFId())) continue;
            target.add(bioPAXElement);
        }
        for (BioPAXElement bioPAXElement : sources) {
            this.updateObjectFields(bioPAXElement, target);
        }
    }

    public void merge(Model target, BioPAXElement source) {
        this.merge(target, Collections.singleton(source));
    }

    private void updateObjectFields(BioPAXElement source, Model target) {
        BioPAXElement keep = target.getByID(source.getRDFId());
        if (keep != source && this.mergeObjPropOf == null) {
            return;
        }
        Set<PropertyEditor> editors = this.map.getEditorsOf(source);
        for (PropertyEditor editor : editors) {
            HashSet values;
            if (editor instanceof ObjectPropertyEditor) {
                values = new HashSet(editor.getValueFromBean(source));
                if (keep == source) {
                    for (BioPAXElement value : values) {
                        this.migrateToTarget(source, target, editor, value);
                    }
                    continue;
                }
                if (this.mergeObjPropOf == null || !this.mergeObjPropOf.filter(source) || !editor.isMultipleCardinality()) continue;
                for (BioPAXElement value : values) {
                    this.mergeToTarget(keep, target, editor, value);
                }
                continue;
            }
            if (this.mergeObjPropOf == null || !this.mergeObjPropOf.filter(source) || !editor.isMultipleCardinality()) continue;
            values = new HashSet(editor.getValueFromBean(source));
            for (BioPAXElement value : values) {
                this.mergeToTarget(keep, target, editor, value);
            }
        }
    }

    private void migrateToTarget(BioPAXElement source, Model target, PropertyEditor editor, BioPAXElement value) {
        if (value != null) {
            BioPAXElement newValue = target.getByID(value.getRDFId());
            assert (newValue != null) : "'newValue' is null (a design flaw in the 'merge' method)";
            if (newValue != value) {
                editor.removeValueFromBean(value, source);
                editor.setValueToBean(newValue, source);
            }
        }
    }

    private void mergeToTarget(BioPAXElement targetElement, Model target, PropertyEditor editor, Object value) {
        if (value != null) {
            Object newValue = value instanceof BioPAXElement ? target.getByID(((BioPAXElement)value).getRDFId()) : value;
            editor.setValueToBean(newValue, targetElement);
        }
    }
}

