/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.impl.level3;

import javax.persistence.Entity;
import javax.persistence.OneToOne;
import javax.persistence.Transient;
import org.biopax.paxtools.impl.level3.EntityFeatureImpl;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.BindingFeature;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Proxy;
import org.hibernate.search.annotations.Indexed;

@Entity
@Proxy(proxyClass=BindingFeature.class)
@Indexed
@DynamicUpdate
@DynamicInsert
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class BindingFeatureImpl
extends EntityFeatureImpl
implements BindingFeature {
    private BindingFeature bindsTo;
    private Boolean intramolecular;

    @Transient
    public Class<? extends BindingFeature> getModelInterface() {
        return BindingFeature.class;
    }

    @Override
    @OneToOne(targetEntity=BindingFeatureImpl.class)
    public BindingFeature getBindsTo() {
        return this.bindsTo;
    }

    @Override
    public void setBindsTo(BindingFeature bindsTo) {
        if (this.bindsTo != bindsTo) {
            BindingFeature old = this.bindsTo;
            this.bindsTo = bindsTo;
            if (old != null && old.getBindsTo() == this) {
                old.setBindsTo(null);
            }
            if (this.bindsTo != null && this.bindsTo.getBindsTo() != this) {
                this.bindsTo.setBindsTo(this);
            }
        }
    }

    @Override
    public Boolean getIntraMolecular() {
        return this.intramolecular;
    }

    @Override
    public void setIntraMolecular(Boolean intramolecular) {
        this.intramolecular = intramolecular;
    }

    @Override
    protected boolean semanticallyEquivalent(BioPAXElement element) {
        if (!(element instanceof BindingFeature)) {
            return false;
        }
        BindingFeature that = (BindingFeature)element;
        return super.semanticallyEquivalent(element) && this.getIntraMolecular() == that.getIntraMolecular() && (this.bindsTo == null ? that.getBindsTo() == null : this.bindsTo.equals(that.getBindsTo()));
    }

    @Override
    public int equivalenceCode() {
        int value = super.equivalenceCode();
        if (this.intramolecular != null) {
            value += this.intramolecular != false ? 29 : 17;
        }
        return value;
    }
}

