/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.impl.level3;

import javax.persistence.Entity;
import javax.persistence.Transient;
import org.biopax.paxtools.impl.level3.ChemicalConstantImpl;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.KPrime;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Proxy;
import org.hibernate.search.annotations.Indexed;

@Entity
@Proxy(proxyClass=KPrime.class)
@Indexed
@DynamicUpdate
@DynamicInsert
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class KPrimeImpl
extends ChemicalConstantImpl
implements KPrime {
    private float kPrime = UNKNOWN_FLOAT.floatValue();

    @Transient
    public Class<? extends KPrime> getModelInterface() {
        return KPrime.class;
    }

    @Override
    protected boolean semanticallyEquivalent(BioPAXElement element) {
        return super.semanticallyEquivalent(element) && Float.compare(((KPrime)element).getKPrime(), this.kPrime) == 0;
    }

    @Override
    public int equivalenceCode() {
        return (float)(super.equivalenceCode() + 29) + this.kPrime != 0.0f ? Float.floatToIntBits(this.kPrime) : 0;
    }

    @Override
    public float getKPrime() {
        return this.kPrime;
    }

    @Override
    public void setKPrime(float prime) {
        this.kPrime = prime;
    }
}

