/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.model;

import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXFactory;
import org.biopax.paxtools.util.IllegalBioPAXArgumentException;

public enum BioPAXLevel {
    L1("biopax-level1.owl", new Level2FactoryImpl(), "org.biopax.paxtools.model.level2"),
    L2("biopax-level2.owl", new Level2FactoryImpl(), "org.biopax.paxtools.model.level2"),
    L3("biopax-level3.owl", new Level3FactoryImpl(), "org.biopax.paxtools.model.level3");

    private static Log log;
    private final String filename;
    private BioPAXFactory factory;
    private final String packageName;
    public static final String BP_PREFIX = "http://www.biopax.org/release/";

    private BioPAXLevel(String filename, BioPAXFactory factory, String pm) {
        this.filename = filename;
        this.packageName = pm;
        this.factory = factory;
    }

    public String getFilename() {
        return this.filename;
    }

    public BioPAXFactory getDefaultFactory() {
        return this.factory;
    }

    public InputStream getLevelFileAsStream() {
        return ((Object)((Object)this)).getClass().getResourceAsStream(this.filename);
    }

    public String getNameSpace() {
        return BP_PREFIX + this.filename + "#";
    }

    public static boolean isInBioPAXNameSpace(String nameSpace) {
        return nameSpace != null && nameSpace.startsWith(BP_PREFIX);
    }

    public static BioPAXLevel getLevelFromNameSpace(String namespace2) {
        if (BioPAXLevel.isInBioPAXNameSpace(namespace2)) {
            for (BioPAXLevel level : BioPAXLevel.values()) {
                if (!namespace2.equalsIgnoreCase(level.getNameSpace())) continue;
                return level;
            }
        }
        return null;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public boolean hasElement(BioPAXElement element) {
        return element.getModelInterface().getPackage().getName().equals(this.packageName);
    }

    public Class<? extends BioPAXElement> getInterfaceForName(String localName) {
        try {
            Class<?> modelInterface = Class.forName(this.packageName + "." + localName);
            if (BioPAXElement.class.isAssignableFrom(modelInterface)) {
                return modelInterface;
            }
            throw new IllegalBioPAXArgumentException("BioPAXElement is not assignable from class:" + modelInterface.getSimpleName());
        }
        catch (ClassNotFoundException e2) {
            throw new IllegalBioPAXArgumentException("Could not locate interface for:" + localName);
        }
    }

    static {
        log = LogFactory.getLog(BioPAXLevel.class);
    }

    private static class Level3FactoryImpl
    extends BioPAXFactory {
        private Level3FactoryImpl() {
        }

        @Override
        public BioPAXLevel getLevel() {
            return L3;
        }

        @Override
        public String mapClassName(Class<? extends BioPAXElement> aClass) {
            String name = "org.biopax.paxtools.impl.level3." + aClass.getSimpleName() + "Impl";
            return name;
        }
    }

    private static class Level2FactoryImpl
    extends BioPAXFactory {
        private Level2FactoryImpl() {
        }

        @Override
        public BioPAXLevel getLevel() {
            return L2;
        }

        @Override
        public String mapClassName(Class<? extends BioPAXElement> aClass) {
            String name = "org.biopax.paxtools.impl.level2." + aClass.getSimpleName() + "Impl";
            return name;
        }
    }
}

