/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.pattern.miner;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.SmallMoleculeReference;
import org.biopax.paxtools.pattern.miner.IDFetcher;
import org.biopax.paxtools.pattern.miner.SIFEnum;
import org.biopax.paxtools.pattern.miner.SIFInteraction;
import org.biopax.paxtools.pattern.miner.SIFSearcher;
import org.biopax.paxtools.pattern.util.Blacklist;
import org.biopax.paxtools.pattern.util.ChemicalNameNormalizer;
import org.biopax.paxtools.pattern.util.RelType;

public class BlacklistGenerator {
    private Decider decider;

    public BlacklistGenerator(Decider decider) {
        this.decider = decider;
    }

    public BlacklistGenerator() {
        this(new Decider(){

            @Override
            public boolean isUbique(int neighborSize, int upstrOnly, int dwstrOnly) {
                return neighborSize >= 30;
            }

            @Override
            public int getScore(int neighborSize, int upstrOnly, int dwstrOnly) {
                return neighborSize;
            }

            @Override
            public RelType getContext(int neighborSize, int upstrOnly, int dwstrOnly) {
                if (upstrOnly > 10 * dwstrOnly) {
                    return RelType.OUTPUT;
                }
                if (dwstrOnly > 10 * upstrOnly) {
                    return RelType.INPUT;
                }
                return null;
            }
        });
    }

    public Blacklist generateBlacklist(Model model) {
        ChemicalNameNormalizer normalizer = new ChemicalNameNormalizer(model);
        SIFSearcher searcher = new SIFSearcher((IDFetcher)new Fetcher(normalizer), SIFEnum.USED_TO_PRODUCE);
        Set<SIFInteraction> sifs = searcher.searchSIF(model);
        HashMap upstrMap = new HashMap();
        HashMap dwstrMap = new HashMap();
        HashMap neighMap = new HashMap();
        for (SIFInteraction sif : sifs) {
            String source = sif.sourceID;
            String target = sif.targetID;
            if (!neighMap.containsKey(source)) {
                neighMap.put(source, new HashSet());
            }
            if (!neighMap.containsKey(target)) {
                neighMap.put(target, new HashSet());
            }
            if (!dwstrMap.containsKey(source)) {
                dwstrMap.put(source, new HashSet());
            }
            if (!dwstrMap.containsKey(target)) {
                dwstrMap.put(target, new HashSet());
            }
            if (!upstrMap.containsKey(source)) {
                upstrMap.put(source, new HashSet());
            }
            if (!upstrMap.containsKey(target)) {
                upstrMap.put(target, new HashSet());
            }
            ((Set)neighMap.get(source)).add(target);
            ((Set)neighMap.get(target)).add(source);
            ((Set)dwstrMap.get(source)).add(target);
            ((Set)upstrMap.get(target)).add(source);
        }
        for (String name : neighMap.keySet()) {
            if (!upstrMap.containsKey(name) || !dwstrMap.containsKey(name)) continue;
            Set upstr = (Set)upstrMap.get(name);
            Set dwstr = (Set)dwstrMap.get(name);
            HashSet temp = new HashSet(upstr);
            upstr.removeAll(dwstr);
            dwstr.removeAll(temp);
        }
        Blacklist blacklist = new Blacklist();
        for (SmallMoleculeReference smr : model.getObjects(SmallMoleculeReference.class)) {
            int dwstrOnly;
            int upstrOnly;
            String name = normalizer.getName(smr);
            int neighSize = neighMap.containsKey(name) ? ((Set)neighMap.get(name)).size() : 0;
            if (!this.decider.isUbique(neighSize, upstrOnly = upstrMap.containsKey(name) ? ((Set)upstrMap.get(name)).size() : 0, dwstrOnly = dwstrMap.containsKey(name) ? ((Set)dwstrMap.get(name)).size() : 0)) continue;
            blacklist.addEntry(smr.getRDFId(), this.decider.getScore(neighSize, upstrOnly, dwstrOnly), this.decider.getContext(neighSize, upstrOnly, dwstrOnly));
        }
        blacklist.write("blacklist.txt");
        return blacklist;
    }

    static interface Decider {
        public boolean isUbique(int var1, int var2, int var3);

        public int getScore(int var1, int var2, int var3);

        public RelType getContext(int var1, int var2, int var3);
    }

    class Fetcher
    implements IDFetcher {
        ChemicalNameNormalizer normalizer;

        Fetcher(ChemicalNameNormalizer normalizer) {
            this.normalizer = normalizer;
        }

        @Override
        public Set<String> fetchID(BioPAXElement ele) {
            if (ele instanceof SmallMoleculeReference) {
                return Collections.singleton(this.normalizer.getName((SmallMoleculeReference)ele));
            }
            return null;
        }
    }
}

