/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.pattern.miner;

import java.util.HashSet;
import java.util.Set;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.DnaReference;
import org.biopax.paxtools.model.level3.RnaReference;
import org.biopax.paxtools.model.level3.SmallMoleculeReference;
import org.biopax.paxtools.model.level3.XReferrable;
import org.biopax.paxtools.model.level3.Xref;
import org.biopax.paxtools.pattern.miner.IDFetcher;
import org.biopax.paxtools.pattern.util.HGNC;

public class CommonIDFetcher
implements IDFetcher {
    boolean useUniprotIDs = false;

    @Override
    public Set<String> fetchID(BioPAXElement ele) {
        String id;
        String db;
        HashSet<String> set = new HashSet<String>();
        if (ele instanceof SmallMoleculeReference) {
            SmallMoleculeReference smr = (SmallMoleculeReference)ele;
            if (smr.getDisplayName() != null) {
                set.add(smr.getDisplayName());
            } else if (!smr.getName().isEmpty()) {
                set.add(smr.getName().iterator().next());
            }
            return set;
        }
        if (this.useUniprotIDs && ele.getRDFId().startsWith("http://identifiers.org/uniprot/")) {
            set.add(ele.getRDFId().substring(ele.getRDFId().lastIndexOf("/") + 1));
        } else if (ele instanceof XReferrable) {
            for (Xref xr : ((XReferrable)ele).getXref()) {
                db = xr.getDb();
                if (db == null) continue;
                db = db.toLowerCase();
                if (!this.useUniprotIDs && db.startsWith("hgnc")) {
                    String symbol;
                    id = xr.getId();
                    if (id == null || (symbol = HGNC.getSymbol(id)) == null || symbol.isEmpty()) continue;
                    set.add(symbol);
                    continue;
                }
                if (!this.useUniprotIDs || !db.startsWith("uniprot") || (id = xr.getId()) == null) continue;
                set.add(id);
            }
        }
        if (set.isEmpty() && (ele instanceof DnaReference || ele instanceof RnaReference)) {
            for (Xref xr : ((XReferrable)ele).getXref()) {
                db = xr.getDb();
                if (db == null || !(db = db.toLowerCase()).equals("mirbase sequence") || (id = xr.getId()) == null || id.isEmpty()) continue;
                set.add(id);
            }
        }
        return set;
    }

    public void setUseUniprotIDs(boolean useUniprotIDs) {
        this.useUniprotIDs = useUniprotIDs;
    }
}

