/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.util;

import java.util.Set;
import org.apache.lucene.document.Document;
import org.biopax.paxtools.model.level3.BioSource;
import org.biopax.paxtools.model.level3.UnificationXref;
import org.biopax.paxtools.model.level3.Xref;
import org.biopax.paxtools.util.ClassFilterSet;
import org.biopax.paxtools.util.FieldBridgeUtils;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.LuceneOptions;

public final class OrganismFieldBridge
implements FieldBridge {
    public void set(String searchFieldName, Object value, Document document, LuceneOptions luceneOptions) {
        if (value instanceof Set) {
            for (BioSource o : (Set)value) {
                if (o == null) continue;
                this.setOrganism(searchFieldName, o, document, luceneOptions);
            }
        } else {
            throw new AssertionError((Object)"bug!");
        }
    }

    private void setOrganism(String searchFieldName, BioSource bs, Document document, LuceneOptions luceneOptions) {
        FieldBridgeUtils.addFieldToDocumentAsIs(luceneOptions, searchFieldName, bs.getRDFId(), document);
        for (String s : bs.getName()) {
            FieldBridgeUtils.addFieldToDocument(luceneOptions, searchFieldName, s, document);
        }
        for (UnificationXref x : new ClassFilterSet<Xref, UnificationXref>(bs.getXref(), UnificationXref.class)) {
            if (x.getId() == null) continue;
            FieldBridgeUtils.addFieldToDocument(luceneOptions, searchFieldName, x.getId(), document);
        }
        if (bs.getTissue() != null) {
            for (String s : bs.getTissue().getTerm()) {
                FieldBridgeUtils.addFieldToDocument(luceneOptions, searchFieldName, s, document);
            }
        }
        if (bs.getCellType() != null) {
            for (String s : bs.getCellType().getTerm()) {
                FieldBridgeUtils.addFieldToDocument(luceneOptions, searchFieldName, s, document);
            }
        }
    }
}

