/*
 * Decompiled with CFR 0.152.
 */
package org.ivis.layout.cise;

import java.util.List;
import org.ivis.layout.LNode;
import org.ivis.layout.cise.CiSENode;
import org.ivis.layout.cise.CiSEOnCircleNodeExt;
import org.ivis.layout.fd.FDLayoutEdge;

public class CiSEEdge
extends FDLayoutEdge {
    protected boolean isIntraCluster = true;

    public CiSEEdge(LNode source, LNode target, Object vEdge) {
        super(source, target, vEdge);
    }

    public boolean crossesWithEdge(CiSEEdge other) {
        boolean result = false;
        CiSEOnCircleNodeExt sourceExt = ((CiSENode)this.source).getOnCircleNodeExt();
        CiSEOnCircleNodeExt targetExt = ((CiSENode)this.target).getOnCircleNodeExt();
        CiSEOnCircleNodeExt otherSourceExt = ((CiSENode)other.source).getOnCircleNodeExt();
        CiSEOnCircleNodeExt otherTargetExt = ((CiSENode)other.target).getOnCircleNodeExt();
        int sourcePos = -1;
        int targetPos = -1;
        int otherSourcePos = -1;
        int otherTargetPos = -1;
        if (sourceExt != null) {
            sourcePos = sourceExt.getIndex();
        }
        if (targetExt != null) {
            targetPos = targetExt.getIndex();
        }
        if (otherSourceExt != null) {
            otherSourcePos = otherSourceExt.getIndex();
        }
        if (otherTargetExt != null) {
            otherTargetPos = otherTargetExt.getIndex();
        }
        if (!this.isInterGraph && !other.isInterGraph) {
            if (this.source.getOwner() != this.target.getOwner()) {
                result = false;
            } else {
                if (sourcePos == -1 || targetPos == -1 || otherSourcePos == -1 || otherTargetPos == -1) {
                    result = false;
                }
                int otherSourceDist = otherSourceExt.getCircDistWithTheNode(sourceExt);
                int otherTargetDist = otherTargetExt.getCircDistWithTheNode(sourceExt);
                int thisTargetDist = targetExt.getCircDistWithTheNode(sourceExt);
                if (thisTargetDist < Math.max(otherSourceDist, otherTargetDist) && thisTargetDist > Math.min(otherSourceDist, otherTargetDist) && otherTargetDist != 0 && otherSourceDist != 0) {
                    result = true;
                }
            }
        } else {
            result = true;
        }
        return result;
    }

    public int calculateTotalCrossingWithList(List edgeList) {
        int totalCrossing = 0;
        for (CiSEEdge edge : edgeList) {
            totalCrossing += this.crossingWithEdge(edge);
        }
        return totalCrossing;
    }

    public int crossingWithEdge(CiSEEdge other) {
        boolean crosses = this.crossesWithEdge(other);
        int result = 0;
        if (crosses) {
            result = 1;
        }
        return result;
    }
}

