/*
 * Decompiled with CFR 0.152.
 */
package org.ivis.layout.sbgn;

import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.LinkedList;
import org.ivis.layout.LGraphManager;
import org.ivis.layout.LNode;
import org.ivis.layout.sbgn.SbgnPDConstants;
import org.ivis.layout.sbgn.SbgnPDEdge;
import org.ivis.layout.sbgn.SbgnPDNode;
import org.ivis.util.IGeometry;
import org.ivis.util.PointD;

public class SbgnProcessNode
extends SbgnPDNode {
    protected SbgnPDNode parentCompound;
    protected SbgnPDNode inputPort;
    protected SbgnPDNode outputPort;
    protected Orientation orientation;
    private RotationPriority rotationPriority;
    private double idealEdgeLength;
    public ArrayList<SbgnPDEdge> consumptionEdges = new ArrayList();
    public ArrayList<SbgnPDEdge> productEdges = new ArrayList();
    public ArrayList<SbgnPDEdge> effectorEdges = new ArrayList();
    protected double netRotationalForce = 0.0;
    public double properEdgeCount;

    public SbgnProcessNode(LGraphManager gm, Object vNode) {
        super(gm, vNode);
    }

    public SbgnProcessNode(LGraphManager gm, Point loc, Dimension size, LNode vNode, String type) {
        super(gm, loc, size, vNode, type);
    }

    public void reconnectEdges(double idealEdgeLength) {
        this.idealEdgeLength = idealEdgeLength;
        for (int i = 0; i < this.getEdges().size(); ++i) {
            SbgnPDEdge sEdge = (SbgnPDEdge)this.getEdges().get(i);
            if (sEdge.type.equals("consumption")) {
                this.getEdges().remove(sEdge);
                sEdge.setTarget(this.inputPort);
                this.inputPort.getEdges().add(sEdge);
                --i;
                continue;
            }
            if (sEdge.type.equals("production")) {
                this.getEdges().remove(sEdge);
                sEdge.setSource(this.outputPort);
                this.outputPort.getEdges().add(sEdge);
                --i;
                continue;
            }
            if (!sEdge.isEffector()) continue;
            this.getEdges().remove(sEdge);
            sEdge.setTarget(this.parentCompound);
            this.parentCompound.getEdges().add(sEdge);
            --i;
        }
    }

    public void connectNodes(SbgnPDNode parentCompound, SbgnPDNode inputPort, SbgnPDNode outputPort) {
        this.parentCompound = parentCompound;
        this.parentCompound.isDummyCompound = true;
        this.inputPort = inputPort;
        this.outputPort = outputPort;
        this.orientation = Orientation.LEFT_TO_RIGHT;
        outputPort.setCenter(this.getCenterX() + 10.0, this.getCenterY());
        inputPort.setCenter(this.getCenterX() - 10.0, this.getCenterY());
    }

    public boolean isRotationNecessary() {
        this.netRotationalForce /= (double)(SbgnPDConstants.ROTATIONAL_FORCE_ITERATION_COUNT * (this.consumptionEdges.size() + this.productEdges.size() + this.effectorEdges.size()));
        if (this.isSwapAvailable()) {
            this.rotationPriority = RotationPriority.SWAP;
            return true;
        }
        if (Math.abs(this.netRotationalForce) > SbgnPDConstants.ROTATION_90_DEGREE) {
            this.rotationPriority = RotationPriority.NINETY_DEGREE;
            return true;
        }
        this.rotationPriority = RotationPriority.NO_ROTATION;
        return false;
    }

    private boolean isSwapAvailable() {
        double obtuseAngleCnt = 0.0;
        double acuteAngleCnt = 0.0;
        for (SbgnPDEdge edge : this.consumptionEdges) {
            if (Math.abs(edge.correspondingAngle) > 90) {
                obtuseAngleCnt += 1.0;
                continue;
            }
            acuteAngleCnt += 1.0;
        }
        for (SbgnPDEdge edge : this.productEdges) {
            if (Math.abs(edge.correspondingAngle) > 90) {
                obtuseAngleCnt += 1.0;
                continue;
            }
            acuteAngleCnt += 1.0;
        }
        return obtuseAngleCnt / (obtuseAngleCnt + acuteAngleCnt) > 0.5;
    }

    public void applyRotation() {
        if (this.rotationPriority == RotationPriority.NINETY_DEGREE) {
            if (this.orientation.equals((Object)Orientation.TOP_TO_BOTTOM)) {
                if (this.netRotationalForce > SbgnPDConstants.ROTATION_90_DEGREE) {
                    this.rotateCompound(90);
                    this.orientation = Orientation.RIGHT_TO_LEFT;
                } else if (this.netRotationalForce < -SbgnPDConstants.ROTATION_90_DEGREE) {
                    this.rotateCompound(-90);
                    this.orientation = Orientation.LEFT_TO_RIGHT;
                }
            } else if (this.orientation.equals((Object)Orientation.BOTTOM_TO_TOP)) {
                if (this.netRotationalForce < -SbgnPDConstants.ROTATION_90_DEGREE) {
                    this.rotateCompound(90);
                    this.orientation = Orientation.LEFT_TO_RIGHT;
                } else if (this.netRotationalForce > SbgnPDConstants.ROTATION_90_DEGREE) {
                    this.rotateCompound(-90);
                    this.orientation = Orientation.RIGHT_TO_LEFT;
                }
            } else if (this.orientation.equals((Object)Orientation.RIGHT_TO_LEFT)) {
                if (this.netRotationalForce > SbgnPDConstants.ROTATION_90_DEGREE) {
                    this.rotateCompound(90);
                    this.orientation = Orientation.BOTTOM_TO_TOP;
                } else if (this.netRotationalForce < -SbgnPDConstants.ROTATION_90_DEGREE) {
                    this.rotateCompound(-90);
                    this.orientation = Orientation.TOP_TO_BOTTOM;
                }
            } else if (this.orientation.equals((Object)Orientation.LEFT_TO_RIGHT)) {
                if (this.netRotationalForce < -SbgnPDConstants.ROTATION_90_DEGREE) {
                    this.rotateCompound(-90);
                    this.orientation = Orientation.BOTTOM_TO_TOP;
                } else if (this.netRotationalForce > SbgnPDConstants.ROTATION_90_DEGREE) {
                    this.rotateCompound(90);
                    this.orientation = Orientation.TOP_TO_BOTTOM;
                }
            }
        } else if (this.rotationPriority == RotationPriority.SWAP) {
            PointD tempCenter = this.inputPort.getCenter();
            this.inputPort.setCenter(this.outputPort.getCenterX(), this.outputPort.getCenterY());
            this.outputPort.setCenter(tempCenter.x, tempCenter.y);
            if (this.orientation.equals((Object)Orientation.TOP_TO_BOTTOM)) {
                this.orientation = Orientation.BOTTOM_TO_TOP;
            } else if (this.orientation.equals((Object)Orientation.BOTTOM_TO_TOP)) {
                this.orientation = Orientation.TOP_TO_BOTTOM;
            } else if (this.orientation.equals((Object)Orientation.LEFT_TO_RIGHT)) {
                this.orientation = Orientation.RIGHT_TO_LEFT;
            } else if (this.orientation.equals((Object)Orientation.RIGHT_TO_LEFT)) {
                this.orientation = Orientation.LEFT_TO_RIGHT;
            }
        }
        this.netRotationalForce = 0.0;
    }

    private void rotateCompound(int rotationDegree) {
        this.rotateNode(this.getCenter(), rotationDegree);
        this.inputPort.rotateNode(this.getCenter(), rotationDegree);
        this.outputPort.rotateNode(this.getCenter(), rotationDegree);
        this.parentCompound.updateBounds();
    }

    public void calcRotationalForces() {
        this.netRotationalForce += this.calcProperlyOrientedEdges();
    }

    public double calcProperlyOrientedEdges() {
        double result;
        int nodeIndex;
        double inputRotSum = 0.0;
        double outputRotSum = 0.0;
        double effectorRotSum = 0.0;
        double stepSum = 0.0;
        this.properEdgeCount = 0.0;
        if (this.consumptionEdges.size() == 0 && this.productEdges.size() == 0) {
            this.initLists();
        }
        PointD inputPortTarget = this.findPortTargetPoint(true, this.orientation);
        PointD outputPortTarget = this.findPortTargetPoint(false, this.orientation);
        for (nodeIndex = 0; nodeIndex < this.consumptionEdges.size(); ++nodeIndex) {
            result = this.calcRotationalForce(true, nodeIndex, inputPortTarget);
            if (Math.abs(result) <= 100.0) {
                this.properEdgeCount += 1.0;
            }
            inputRotSum += result;
        }
        for (nodeIndex = 0; nodeIndex < this.productEdges.size(); ++nodeIndex) {
            result = this.calcRotationalForce(false, nodeIndex, outputPortTarget);
            if (Math.abs(result) <= 100.0) {
                this.properEdgeCount += 1.0;
            }
            outputRotSum += result;
        }
        for (nodeIndex = 0; nodeIndex < this.effectorEdges.size(); ++nodeIndex) {
            result = this.calcEffectorAngle(nodeIndex);
            if (Math.abs(result) <= 45.0) {
                this.properEdgeCount += 1.0;
            }
            effectorRotSum += Math.abs(result);
        }
        stepSum = inputRotSum - outputRotSum;
        stepSum += Math.signum(stepSum) * Math.abs(effectorRotSum);
        return stepSum;
    }

    private double calcRotationalForce(boolean isInputPort, int nodeIndex, PointD targetPoint) {
        PointD centerPoint;
        SbgnPDNode node;
        if (isInputPort) {
            node = (SbgnPDNode)this.consumptionEdges.get(nodeIndex).getSource();
            centerPoint = this.inputPort.getCenter();
        } else {
            node = (SbgnPDNode)this.productEdges.get(nodeIndex).getTarget();
            centerPoint = this.outputPort.getCenter();
        }
        double angle = IGeometry.calculateAngle(targetPoint, centerPoint, node.getCenter());
        angle = isInputPort ? (angle *= (double)this.isLeft(targetPoint, centerPoint, node.getCenter(), "input_port")) : (angle *= (double)this.isLeft(targetPoint, centerPoint, node.getCenter(), "output_port"));
        this.saveInformation(isInputPort, nodeIndex, angle);
        return angle;
    }

    private double calcEffectorAngle(int nodeIndex) {
        SbgnPDNode eff = (SbgnPDNode)this.effectorEdges.get(nodeIndex).getSource();
        PointD targetPnt = new PointD();
        PointD centerPnt = this.getCenter();
        if (this.isHorizontal()) {
            targetPnt.x = this.getCenterX();
            targetPnt.y = eff.getCenterY() > this.getCenterY() ? this.getCenterY() + this.idealEdgeLength : this.getCenterY() - this.idealEdgeLength;
        } else if (this.isVertical()) {
            targetPnt.y = this.getCenterY();
            targetPnt.x = eff.getCenterX() > this.getCenterX() ? this.getCenterX() + this.idealEdgeLength : this.getCenterX() - this.idealEdgeLength;
        }
        double angle = IGeometry.calculateAngle(targetPnt, centerPnt, eff.getCenter());
        this.effectorEdges.get((int)nodeIndex).correspondingAngle = (int)angle;
        this.effectorEdges.get((int)nodeIndex).isProperlyOriented = Math.abs(angle) <= 45.0;
        return angle;
    }

    public void applyApproximations() {
        if (this.consumptionEdges.size() == 1 && this.consumptionEdges.get(0).getSource().getEdges().size() == 1) {
            this.approximateForSingleNodes(this.inputPort, (SbgnPDNode)this.consumptionEdges.get(0).getSource());
        } else {
            this.approximateForMultipleNodes(this.inputPort);
        }
        if (this.productEdges.size() == 1 && this.productEdges.get(0).getTarget().getEdges().size() == 1) {
            this.approximateForSingleNodes(this.outputPort, (SbgnPDNode)this.productEdges.get(0).getTarget());
        } else {
            this.approximateForMultipleNodes(this.outputPort);
        }
        this.approximateEffectors();
    }

    private void approximateForSingleNodes(SbgnPDNode port, SbgnPDNode node) {
        PointD targetPt = new PointD();
        PointD newPoint = new PointD();
        if (port.isInputPort()) {
            targetPt = this.findPortTargetPoint(true, this.orientation);
        } else if (port.isOutputPort()) {
            targetPt = this.findPortTargetPoint(false, this.orientation);
        }
        newPoint.x = targetPt.x + Math.random() * (double)SbgnPDConstants.APPROXIMATION_DISTANCE * 2.0 - (double)SbgnPDConstants.APPROXIMATION_DISTANCE;
        newPoint.y = targetPt.y + Math.random() * (double)SbgnPDConstants.APPROXIMATION_DISTANCE * 2.0 - (double)SbgnPDConstants.APPROXIMATION_DISTANCE;
        node.setCenter(newPoint.x, newPoint.y);
    }

    private void approximateForMultipleNodes(SbgnPDNode port) {
        LinkedList<SbgnPDNode> oneEdgeNodes = new LinkedList<SbgnPDNode>();
        LinkedList<SbgnPDNode> multiEdgeNodes = new LinkedList<SbgnPDNode>();
        SbgnPDNode nodeOfInterest = null;
        PointD targetPt = new PointD();
        for (Object e2 : port.getEdges()) {
            SbgnPDEdge edge = (SbgnPDEdge)e2;
            if (edge.isRigidEdge()) continue;
            if (port.isInputPort()) {
                nodeOfInterest = (SbgnPDNode)edge.getSource();
            } else if (port.isOutputPort()) {
                nodeOfInterest = (SbgnPDNode)edge.getTarget();
            }
            if (nodeOfInterest.getEdges().size() == 1) {
                oneEdgeNodes.add(nodeOfInterest);
                continue;
            }
            if (nodeOfInterest.getEdges().size() <= 1) continue;
            multiEdgeNodes.add(nodeOfInterest);
        }
        if (port.isInputPort()) {
            targetPt = this.findPortTargetPoint(true, this.orientation);
        } else if (port.isOutputPort()) {
            targetPt = this.findPortTargetPoint(false, this.orientation);
        }
        if (oneEdgeNodes.size() > 0) {
            this.moveOneEdgeNodes(oneEdgeNodes, multiEdgeNodes, targetPt);
        }
    }

    private void moveOneEdgeNodes(LinkedList<SbgnPDNode> oneEdgeNodes, LinkedList<SbgnPDNode> multiEdgeNodes, PointD targetPt) {
        PointD approximationPnt = new PointD(0.0, 0.0);
        int randomIndex = -1;
        SbgnPDNode approximationNode = null;
        PointD newPoint = new PointD();
        if (multiEdgeNodes.size() > 0) {
            approximationNode = multiEdgeNodes.get(0);
            for (SbgnPDNode node : multiEdgeNodes) {
                if (node.getEdges().size() <= approximationNode.getEdges().size()) continue;
                approximationNode = node;
            }
        } else if (multiEdgeNodes.size() == 0) {
            randomIndex = (int)(Math.random() * (double)oneEdgeNodes.size());
            approximationNode = oneEdgeNodes.get(randomIndex);
        }
        approximationPnt = approximationNode.getCenter();
        for (SbgnPDNode s : oneEdgeNodes) {
            newPoint.x = approximationPnt.x + Math.random() * (double)SbgnPDConstants.APPROXIMATION_DISTANCE * 2.0 - (double)SbgnPDConstants.APPROXIMATION_DISTANCE;
            newPoint.y = approximationPnt.y + Math.random() * (double)SbgnPDConstants.APPROXIMATION_DISTANCE * 2.0 - (double)SbgnPDConstants.APPROXIMATION_DISTANCE;
            s.setCenter(newPoint.x, newPoint.y);
        }
    }

    public void approximateEffectors() {
        PointD newPoint = new PointD();
        PointD approximationPnt = new PointD();
        for (SbgnPDEdge edge : this.effectorEdges) {
            if (edge.getSource().getEdges().size() != 1) continue;
            approximationPnt = this.findEffectorTargetPoint((SbgnPDNode)edge.getSource());
            newPoint.x = approximationPnt.x + Math.random() * (double)SbgnPDConstants.APPROXIMATION_DISTANCE * 2.0 - (double)SbgnPDConstants.APPROXIMATION_DISTANCE;
            newPoint.y = approximationPnt.y + Math.random() * (double)SbgnPDConstants.APPROXIMATION_DISTANCE * 2.0 - (double)SbgnPDConstants.APPROXIMATION_DISTANCE;
            edge.getSource().setCenter(newPoint.x, newPoint.y);
        }
    }

    private PointD findEffectorTargetPoint(SbgnPDNode eff) {
        PointD approximationPnt = new PointD();
        if (this.isHorizontal()) {
            approximationPnt.x = this.getCenterX();
            approximationPnt.y = eff.getCenterY() > this.getCenterY() ? this.getCenterY() + this.idealEdgeLength : this.getCenterY() - this.idealEdgeLength;
        } else if (this.isVertical()) {
            approximationPnt.y = this.getCenterY();
            approximationPnt.x = eff.getCenterX() > this.getCenterX() ? this.getCenterX() + this.idealEdgeLength : this.getCenterX() - this.idealEdgeLength;
        }
        return approximationPnt;
    }

    public PointD findPortTargetPoint(boolean isInputPort, Orientation orient) {
        if (orient.equals((Object)Orientation.LEFT_TO_RIGHT)) {
            if (isInputPort) {
                return new PointD(this.inputPort.getCenterX() - this.idealEdgeLength, this.inputPort.getCenterY());
            }
            return new PointD(this.outputPort.getCenterX() + this.idealEdgeLength, this.outputPort.getCenterY());
        }
        if (orient.equals((Object)Orientation.RIGHT_TO_LEFT)) {
            if (isInputPort) {
                return new PointD(this.inputPort.getCenterX() + this.idealEdgeLength, this.inputPort.getCenterY());
            }
            return new PointD(this.outputPort.getCenterX() - this.idealEdgeLength, this.outputPort.getCenterY());
        }
        if (orient.equals((Object)Orientation.TOP_TO_BOTTOM)) {
            if (isInputPort) {
                return new PointD(this.inputPort.getCenterX(), this.inputPort.getCenterY() - this.idealEdgeLength);
            }
            return new PointD(this.outputPort.getCenterX(), this.outputPort.getCenterY() + this.idealEdgeLength);
        }
        if (orient.equals((Object)Orientation.BOTTOM_TO_TOP)) {
            if (isInputPort) {
                return new PointD(this.inputPort.getCenterX(), this.inputPort.getCenterY() + this.idealEdgeLength);
            }
            return new PointD(this.outputPort.getCenterX(), this.outputPort.getCenterY() - this.idealEdgeLength);
        }
        return null;
    }

    private void initLists() {
        SbgnPDEdge edge;
        for (Object o : this.inputPort.getEdges()) {
            edge = (SbgnPDEdge)o;
            if (edge.isRigidEdge()) continue;
            this.consumptionEdges.add(edge);
        }
        for (Object o : this.outputPort.getEdges()) {
            edge = (SbgnPDEdge)o;
            if (edge.isRigidEdge()) continue;
            this.productEdges.add(edge);
        }
        for (Object o : this.parentCompound.getEdges()) {
            edge = (SbgnPDEdge)o;
            if (!edge.isEffector()) continue;
            this.effectorEdges.add(edge);
        }
    }

    private void saveInformation(boolean isInputPort, int nodeIndex, double angle) {
        if (isInputPort) {
            this.consumptionEdges.get((int)nodeIndex).correspondingAngle = (int)angle;
        } else {
            this.productEdges.get((int)nodeIndex).correspondingAngle = (int)angle;
        }
        if (Math.abs(angle) <= 100.0) {
            if (isInputPort) {
                this.consumptionEdges.get((int)nodeIndex).isProperlyOriented = true;
            } else {
                this.productEdges.get((int)nodeIndex).isProperlyOriented = true;
            }
        } else if (isInputPort) {
            this.consumptionEdges.get((int)nodeIndex).isProperlyOriented = false;
        } else {
            this.productEdges.get((int)nodeIndex).isProperlyOriented = false;
        }
    }

    public int isLeft(PointD a, PointD b, PointD c, String type) {
        if ((b.x - a.x) * (c.y - a.y) - (b.y - a.y) * (c.x - a.x) > 0.0) {
            if (this.orientation.equals((Object)Orientation.TOP_TO_BOTTOM)) {
                if (type.equals("input_port")) {
                    return -1;
                }
                if (type.equals("output_port")) {
                    return 1;
                }
            } else if (this.orientation.equals((Object)Orientation.BOTTOM_TO_TOP)) {
                if (type.equals("input_port")) {
                    return 1;
                }
                if (type.equals("output_port")) {
                    return -1;
                }
            } else if (this.orientation.equals((Object)Orientation.LEFT_TO_RIGHT)) {
                if (type.equals("input_port")) {
                    return 1;
                }
                if (type.equals("output_port")) {
                    return -1;
                }
            } else if (this.orientation.equals((Object)Orientation.RIGHT_TO_LEFT)) {
                if (type.equals("input_port")) {
                    return -1;
                }
                if (type.equals("output_port")) {
                    return 1;
                }
            }
        } else if (this.orientation.equals((Object)Orientation.TOP_TO_BOTTOM)) {
            if (type.equals("input_port")) {
                return 1;
            }
            if (type.equals("output_port")) {
                return -1;
            }
        } else if (this.orientation.equals((Object)Orientation.BOTTOM_TO_TOP)) {
            if (type.equals("input_port")) {
                return -1;
            }
            if (type.equals("output_port")) {
                return 1;
            }
        } else if (this.orientation.equals((Object)Orientation.LEFT_TO_RIGHT)) {
            if (type.equals("input_port")) {
                return -1;
            }
            if (type.equals("output_port")) {
                return 1;
            }
        } else if (this.orientation.equals((Object)Orientation.RIGHT_TO_LEFT)) {
            if (type.equals("input_port")) {
                return 1;
            }
            if (type.equals("output_port")) {
                return -1;
            }
        }
        return 0;
    }

    public void copyNode(SbgnProcessNode s, LGraphManager graphManager) {
        this.type = s.type;
        this.label = s.label;
        this.parentCompound = s.parentCompound;
        this.inputPort = s.inputPort;
        this.outputPort = s.outputPort;
        this.setCenter(s.getCenterX(), s.getCenterY());
        this.setChild(s.getChild());
        this.setHeight(s.getHeight());
        this.setLocation(s.getLocation().x, s.getLocation().y);
        this.setNext(s.getNext());
        this.setOwner(s.getOwner());
        this.setPred1(s.getPred1());
        this.setPred2(s.getPred2());
        this.setWidth(s.getWidth());
    }

    public void copyFromSBGNPDNode(SbgnPDNode s, LGraphManager graphManager) {
        this.type = s.type;
        this.label = s.label;
        this.setCenter(s.getCenterX(), s.getCenterY());
        this.setChild(s.getChild());
        this.setHeight(s.getHeight());
        this.setLocation(s.getLocation().x, s.getLocation().y);
        this.setNext(s.getNext());
        this.setOwner(s.getOwner());
        this.setPred1(s.getPred1());
        this.setPred2(s.getPred2());
        this.setWidth(s.getWidth());
        for (Object o : s.getEdges()) {
            SbgnPDEdge edge = (SbgnPDEdge)o;
            SbgnPDEdge newEdge = new SbgnPDEdge((SbgnPDNode)edge.getSource(), (SbgnPDNode)edge.getTarget(), null, edge.type);
            newEdge.copy(edge);
            if (edge.getSource().equals(s)) {
                newEdge.setSource(this);
            } else if (edge.getTarget().equals(s)) {
                newEdge.setTarget(this);
            }
            graphManager.add(newEdge, newEdge.getSource(), newEdge.getTarget());
        }
    }

    public boolean isVertical() {
        return this.orientation.equals((Object)Orientation.TOP_TO_BOTTOM) || this.orientation.equals((Object)Orientation.BOTTOM_TO_TOP);
    }

    public boolean isHorizontal() {
        return this.orientation.equals((Object)Orientation.LEFT_TO_RIGHT) || this.orientation.equals((Object)Orientation.RIGHT_TO_LEFT);
    }

    public void setOrientation(Orientation orient) {
        this.orientation = orient;
        if (this.orientation.equals((Object)Orientation.LEFT_TO_RIGHT)) {
            this.inputPort.setCenter(this.getCenterX() - 10.0, this.getCenterY());
            this.outputPort.setCenter(this.getCenterX() + 10.0, this.getCenterY());
        } else if (this.orientation.equals((Object)Orientation.RIGHT_TO_LEFT)) {
            this.inputPort.setCenter(this.getCenterX() + 10.0, this.getCenterY());
            this.outputPort.setCenter(this.getCenterX() - 10.0, this.getCenterY());
        } else if (this.orientation.equals((Object)Orientation.BOTTOM_TO_TOP)) {
            this.inputPort.setCenter(this.getCenterX(), this.getCenterY() + 10.0);
            this.outputPort.setCenter(this.getCenterX(), this.getCenterY() - 10.0);
        } else if (this.orientation.equals((Object)Orientation.TOP_TO_BOTTOM)) {
            this.inputPort.setCenter(this.getCenterX(), this.getCenterY() - 10.0);
            this.outputPort.setCenter(this.getCenterX(), this.getCenterY() + 10.0);
        }
    }

    public void transferForces() {
        this.parentCompound.springForceX += this.springForceX + this.inputPort.springForceX + this.outputPort.springForceX;
        this.parentCompound.springForceY += this.springForceY + this.inputPort.springForceY + this.outputPort.springForceY;
    }

    public SbgnPDNode getInputPort() {
        return this.inputPort;
    }

    public SbgnPDNode getOutputPort() {
        return this.outputPort;
    }

    public SbgnPDNode getParentCompound() {
        return this.parentCompound;
    }

    public static enum RotationPriority {
        NINETY_DEGREE,
        SWAP,
        NO_ROTATION;

    }

    public static enum Orientation {
        BOTTOM_TO_TOP,
        TOP_TO_BOTTOM,
        LEFT_TO_RIGHT,
        RIGHT_TO_LEFT;

    }
}

