/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.client.batch;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import javax.xml.bind.JAXBException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.mi.tab.PsimiTabWriter;
import psidev.psi.mi.tab.converter.xml2tab.TabConversionException;
import psidev.psi.mi.tab.converter.xml2tab.Xml2Tab;
import psidev.psi.mi.tab.model.BinaryInteraction;
import psidev.psi.mi.tab.processor.ClusterInteractorPairProcessor;
import psidev.psi.mi.xml.converter.ConverterException;

public class ProcessDirectory {
    public static final Log log = LogFactory.getLog(ProcessDirectory.class);

    public static void main(String[] args) throws JAXBException, IOException, TabConversionException, ConverterException {
        File dir;
        if (args.length != 1) {
            System.err.println("usage: ProcessDirectory <dir>");
            System.exit(1);
        }
        if (!(dir = new File(args[0])).exists()) {
            throw new IllegalArgumentException("Directory doesn't exists: " + dir.getAbsolutePath());
        }
        if (!dir.canRead()) {
            throw new IllegalArgumentException("Cannot read directory: " + dir.getAbsolutePath());
        }
        long start = System.currentTimeMillis();
        Xml2Tab x2t = new Xml2Tab();
        x2t.setPostProcessor(new ClusterInteractorPairProcessor());
        System.out.println("Applying Spoke model expansion wherever appropriate.");
        Collection<BinaryInteraction> interactions = x2t.convert(dir);
        PsimiTabWriter writer = new PsimiTabWriter();
        writer.write(interactions, new File("C:\\psimitab.csv"));
        long stop = System.currentTimeMillis();
        log.debug("Conversion took: " + (stop - start) + "ms");
    }
}

