/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.converter.xml2tab;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.mi.xml.model.Alias;
import psidev.psi.mi.xml.model.Names;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AliasUtils {
    public static final Log log = LogFactory.getLog(AliasUtils.class);
    public static final String PSI_MI = "psi-mi";
    public static final String PSI_MI_REF = "MI:0488";
    public static final String GENE_NAME = "gene name";
    public static final String GENE_NAME_MI_REF = "MI:0301";

    public static Collection<Alias> searchByType(Collection<Alias> aliases, String type, String miRef) {
        if (type == null && miRef == null) {
            throw new IllegalArgumentException("You must give either a type of an MI reference (or both).");
        }
        ArrayList<Alias> collected = new ArrayList<Alias>(2);
        for (Alias alias : aliases) {
            if (type != null) {
                if (!type.equalsIgnoreCase(alias.getType())) continue;
                collected.add(alias);
                continue;
            }
            if (miRef == null || !miRef.equalsIgnoreCase(alias.getTypeAc())) continue;
            collected.add(alias);
        }
        return collected;
    }

    public static Alias getGeneName(Collection<Alias> aliases) {
        for (Alias alias : aliases) {
            if (!GENE_NAME.equalsIgnoreCase(alias.getType()) && !GENE_NAME_MI_REF.equalsIgnoreCase(alias.getTypeAc())) continue;
            return alias;
        }
        return null;
    }

    @Deprecated
    public static Collection<Alias> getAllAliases(Names names) {
        ArrayList<Alias> aliases = new ArrayList<Alias>(names.getAliases().size());
        for (Alias alias : names.getAliases()) {
            aliases.add(alias);
        }
        return aliases;
    }
}

