/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.xml.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import psidev.psi.mi.xml.PsimiXmlVersion;
import psidev.psi.mi.xml.model.Alias;
import psidev.psi.mi.xml.model.Attribute;
import psidev.psi.mi.xml.model.Bibref;
import psidev.psi.mi.xml.model.BiologicalRole;
import psidev.psi.mi.xml.model.Confidence;
import psidev.psi.mi.xml.model.CvType;
import psidev.psi.mi.xml.model.DbReference;
import psidev.psi.mi.xml.model.Entry;
import psidev.psi.mi.xml.model.EntrySet;
import psidev.psi.mi.xml.model.ExperimentDescription;
import psidev.psi.mi.xml.model.ExperimentalRole;
import psidev.psi.mi.xml.model.Feature;
import psidev.psi.mi.xml.model.FeatureType;
import psidev.psi.mi.xml.model.HasId;
import psidev.psi.mi.xml.model.Interaction;
import psidev.psi.mi.xml.model.InteractionDetectionMethod;
import psidev.psi.mi.xml.model.InteractionType;
import psidev.psi.mi.xml.model.Interactor;
import psidev.psi.mi.xml.model.InteractorType;
import psidev.psi.mi.xml.model.Names;
import psidev.psi.mi.xml.model.Organism;
import psidev.psi.mi.xml.model.Participant;
import psidev.psi.mi.xml.model.ParticipantIdentificationMethod;
import psidev.psi.mi.xml.model.Position;
import psidev.psi.mi.xml.model.Range;
import psidev.psi.mi.xml.model.RangeStatus;
import psidev.psi.mi.xml.model.Source;
import psidev.psi.mi.xml.model.Unit;
import psidev.psi.mi.xml.model.Xref;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PsiFactory {
    private static int id = 1;

    private PsiFactory() {
    }

    public static EntrySet createEntrySet(PsimiXmlVersion version2, Entry ... entries) {
        return PsiFactory.createEntrySet(version2, Arrays.asList(entries));
    }

    public static EntrySet createEntrySet(PsimiXmlVersion version2, Collection<Entry> entries) {
        EntrySet entrySet = new EntrySet(version2);
        entrySet.getEntries().addAll(entries);
        return entrySet;
    }

    public static Entry createEntry(Source source, Collection<Interaction> interactions) {
        Entry entry = new Entry();
        entry.setSource(source);
        for (Interaction interaction2 : interactions) {
            entry.getInteractions().add(interaction2);
            for (ExperimentDescription expDesc : interaction2.getExperiments()) {
                entry.getExperiments().add(expDesc);
            }
            for (Participant part : interaction2.getParticipants()) {
                entry.getInteractors().add(part.getInteractor());
            }
        }
        return entry;
    }

    public static void assignNextId(Object object) {
        if (object instanceof HasId) {
            ((HasId)object).setId(id++);
        }
    }

    public static Source createSource(String name) {
        return PsiFactory.createSource(name, null, null, null);
    }

    public static Source createSource(String name, String description, String sourcePublicationId, String miId) {
        Source source = new Source();
        Names names = PsiFactory.createNames(name, description);
        source.setNames(names);
        if (miId != null) {
            Xref miRef = PsiFactory.createXrefPsiMi(miId);
            source.setXref(miRef);
        }
        if (sourcePublicationId != null) {
            source.setBibref(PsiFactory.createBibrefPubmed(sourcePublicationId));
        }
        return source;
    }

    public static Names createNames(String name, String description) {
        Names names = new Names();
        names.setShortLabel(name);
        names.setFullName(description);
        return names;
    }

    public static Bibref createBibrefPubmed(String publicationId) {
        return PsiFactory.createBibref(publicationId, "MI:0446", "pubmed");
    }

    public static Bibref createBibref(String publicationId, String dbAc, String dbName) {
        DbReference dbReference = PsiFactory.createDbReference(publicationId, dbAc, dbName, "MI:0358", "primary-reference");
        Xref xref2 = new Xref(dbReference);
        return new Bibref(xref2);
    }

    public static Interaction createInteraction(String name, ExperimentDescription experiment, InteractionType interactionType, Collection<Participant> participants) {
        Interaction interaction2 = new Interaction();
        PsiFactory.assignNextId(interaction2);
        interaction2.setNames(PsiFactory.createNames(name, null));
        for (Participant participant : participants) {
            interaction2.getParticipants().add(participant);
        }
        interaction2.getInteractionTypes().add(interactionType);
        interaction2.getExperiments().add(experiment);
        return interaction2;
    }

    public static InteractionType createInteractionType(String mi, String name) {
        return PsiFactory.createCvType(InteractionType.class, mi, name);
    }

    public static Participant createParticipant(Interactor interactor, BiologicalRole biologicalRole, ExperimentalRole experimentalRole) {
        Participant participant = new Participant();
        PsiFactory.assignNextId(participant);
        participant.setInteractor(interactor);
        participant.setBiologicalRole(biologicalRole);
        participant.getExperimentalRoles().add(experimentalRole);
        return participant;
    }

    public static Participant createParticipantBait(Interactor interactor) {
        BiologicalRole biologicalRole = PsiFactory.createBiologicalRoleUnspecified();
        ExperimentalRole experimentalRole = PsiFactory.createExperimentalRoleBait();
        return PsiFactory.createParticipant(interactor, biologicalRole, experimentalRole);
    }

    public static Participant createParticipantPrey(Interactor interactor) {
        BiologicalRole biologicalRole = PsiFactory.createBiologicalRoleUnspecified();
        ExperimentalRole experimentalRole = PsiFactory.createExperimentalRolePrey();
        return PsiFactory.createParticipant(interactor, biologicalRole, experimentalRole);
    }

    public static ParticipantIdentificationMethod createParticipantIdentificationMethod(String mi, String name) {
        return PsiFactory.createCvType(ParticipantIdentificationMethod.class, mi, name);
    }

    public static ParticipantIdentificationMethod createParticipantIdentificationMethodPredetermined() {
        return PsiFactory.createParticipantIdentificationMethod("MI:0396", "predetermined");
    }

    public static BiologicalRole createBiologicalRole(String mi, String name) {
        return PsiFactory.createCvType(BiologicalRole.class, mi, name);
    }

    public static BiologicalRole createBiologicalRoleUnspecified() {
        return PsiFactory.createBiologicalRole("MI:0499", "unspecified role");
    }

    public static ExperimentalRole createExperimentalRole(String mi, String name) {
        return PsiFactory.createCvType(ExperimentalRole.class, mi, name);
    }

    public static ExperimentalRole createExperimentalRoleUnspecified() {
        return PsiFactory.createExperimentalRole("MI:0499", "unspecified role");
    }

    public static ExperimentalRole createExperimentalRoleBait() {
        return PsiFactory.createExperimentalRole("MI:0496", "bait");
    }

    public static ExperimentalRole createExperimentalRolePrey() {
        return PsiFactory.createExperimentalRole("MI:0498", "prey");
    }

    public static Interactor createInteractor(String primaryId, String dbMi, InteractorType interactorType, Organism organism) {
        Interactor interactor = new Interactor();
        PsiFactory.assignNextId(interactor);
        interactor.setNames(PsiFactory.createNames(primaryId, null));
        interactor.setInteractorType(interactorType);
        interactor.setOrganism(organism);
        interactor.setXref(PsiFactory.createXrefIdentity(primaryId, dbMi, dbMi));
        return interactor;
    }

    public static Interactor createInteractorUniprotProtein(String primaryId, int taxId, String organismName) {
        return PsiFactory.createInteractorUniprotProtein(primaryId, PsiFactory.createOrganism(taxId, organismName));
    }

    public static Interactor createInteractorUniprotProtein(String primaryId, Organism organism) {
        InteractorType interactorType = PsiFactory.createInteractorType("MI:0326", "protein");
        return PsiFactory.createInteractor(primaryId, "MI:0486", interactorType, organism);
    }

    public static Interactor createInteractorChebiSmallMolecule(String primaryId, int taxId, String organismName) {
        Organism organism = PsiFactory.createOrganism(taxId, organismName);
        InteractorType interactorType = PsiFactory.createInteractorType("MI:0328", "small molecule");
        return PsiFactory.createInteractor(primaryId, "MI:0474", interactorType, organism);
    }

    public static ExperimentDescription createExperiment(String name, String publicationId, InteractionDetectionMethod interactionDetectionMethod, ParticipantIdentificationMethod participantIdentificationMethod, Organism hostOrganism) {
        ExperimentDescription experiment = new ExperimentDescription();
        PsiFactory.assignNextId(experiment);
        experiment.setNames(PsiFactory.createNames(name, null));
        experiment.setBibref(PsiFactory.createBibrefPubmed(publicationId));
        experiment.setInteractionDetectionMethod(interactionDetectionMethod);
        experiment.setParticipantIdentificationMethod(participantIdentificationMethod);
        experiment.getHostOrganisms().add(hostOrganism);
        return experiment;
    }

    public static InteractionDetectionMethod createInteractionDetectionMethod(String mi, String label) {
        return PsiFactory.createCvType(InteractionDetectionMethod.class, mi, label);
    }

    public static Confidence createConfidence(String value, String unitMi, String unitName) {
        Unit unit = PsiFactory.createCvType(Unit.class, unitMi, unitName);
        return new Confidence(unit, value);
    }

    public static Organism createOrganism(int taxid, String name) {
        Organism organism = new Organism();
        organism.setNames(PsiFactory.createNames(name, null));
        organism.setNcbiTaxId(taxid);
        return organism;
    }

    public static Organism createOrganismHuman() {
        return PsiFactory.createOrganism(9606, "human");
    }

    public static Organism createOrganismInVitro() {
        return PsiFactory.createOrganism(-1, "in vitro");
    }

    public static Organism createOrganismChemicalSynthesis() {
        return PsiFactory.createOrganism(-2, "chemical synthesis");
    }

    public static Organism createOrganismUnknown() {
        return PsiFactory.createOrganism(-3, "unknown");
    }

    public static Organism createOrganismInVivo() {
        return PsiFactory.createOrganism(-4, "in vivo");
    }

    public static Organism createOrganismInSilico() {
        return PsiFactory.createOrganism(-5, "in silico");
    }

    public static Xref createXrefPsiMi(String primaryId) {
        return PsiFactory.createXrefIdentity(primaryId, "MI:0488", "psi-mi");
    }

    public static Xref createXref(String primaryId, String dbMi, String dbName, String qualifierMi, String qualifierName) {
        Xref xref2 = new Xref();
        xref2.setPrimaryRef(PsiFactory.createDbReference(primaryId, dbMi, dbName, qualifierMi, qualifierName));
        return xref2;
    }

    public static Xref createXrefIdentity(String primaryId, String dbMi, String dbName) {
        Xref xref2 = new Xref();
        xref2.setPrimaryRef(PsiFactory.createDbReference(primaryId, dbMi, dbName, "MI:0356", "identity"));
        return xref2;
    }

    public static Alias createAlias(String value, String aliasType, String aliasTypeAc) {
        Alias alias = new Alias();
        alias.setValue(value);
        alias.setType(aliasType);
        alias.setTypeAc(aliasTypeAc);
        return alias;
    }

    private static <C extends CvType> C createCvType(Class<C> cvTypeClass, String name) {
        CvType cv;
        try {
            cv = (CvType)cvTypeClass.newInstance();
            cv.setNames(PsiFactory.createNames(name, null));
        }
        catch (Exception e2) {
            throw new IllegalArgumentException("Is this a cvType?: " + cvTypeClass, e2);
        }
        return (C)cv;
    }

    public static <C extends CvType> C createCvType(Class<C> cvTypeClass, String miRef, String label) {
        C cv = PsiFactory.createCvType(cvTypeClass, label);
        ((CvType)cv).setXref(PsiFactory.createXrefPsiMi(miRef));
        return cv;
    }

    public static InteractorType createInteractorType(String mi, String name) {
        InteractorType intType = PsiFactory.createCvType(InteractorType.class, name);
        intType.setXref(PsiFactory.createXrefPsiMi(mi));
        return intType;
    }

    public static Attribute createAttribute(String name, String value) {
        return new Attribute(name, value);
    }

    public static DbReference createDbReference(String primaryId, String dbAc, String dbName, String refTypeAc, String refTypeName) {
        DbReference dbRef = new DbReference();
        dbRef.setId(primaryId);
        dbRef.setDbAc(dbAc);
        dbRef.setDb(dbName);
        dbRef.setRefType(refTypeName);
        dbRef.setRefTypeAc(refTypeAc);
        return dbRef;
    }

    public static DbReference createDbReferencePsiMi(String psiMiRef) {
        DbReference ref = PsiFactory.createDbReferenceIdentity(psiMiRef, "MI:0488", "psi-mi");
        ref.setId(psiMiRef);
        return ref;
    }

    public static DbReference createDbReferenceIdentity(String primaryId, String dbAc, String dbName) {
        return PsiFactory.createDbReference(primaryId, dbAc, dbName, "MI:0356", "identity");
    }

    public static Feature createFeature(String name, FeatureType featureType, Range range) {
        return PsiFactory.createFeature(name, featureType, Collections.singleton(range));
    }

    public static Feature createFeature(String name, FeatureType featureType, Collection<Range> ranges) {
        Feature feature = new Feature();
        PsiFactory.assignNextId(feature);
        feature.setNames(PsiFactory.createNames(name, name));
        feature.getRanges().addAll(ranges);
        feature.setFeatureType(featureType);
        return feature;
    }

    public static FeatureType createFeatureType(String mi, String label) {
        return PsiFactory.createCvType(FeatureType.class, mi, label);
    }

    public static FeatureType createFeatureTypeSufficientBinding() {
        return PsiFactory.createCvType(FeatureType.class, "MI:0442", "sufficient for binding");
    }

    public static FeatureType createFeatureTypeMutation() {
        return PsiFactory.createCvType(FeatureType.class, "MI:0118", "mutation");
    }

    public static Range createRange(RangeStatus startStatus, RangeStatus endStatus, long startPosition, long endPosition) {
        Position start = new Position(startPosition);
        Position end = new Position(endPosition);
        return new Range(startStatus, start, endStatus, end);
    }

    public static Range createRangeCertain(long startPosition, long endPosition) {
        Position start = new Position(startPosition);
        Position end = new Position(endPosition);
        return new Range(PsiFactory.createRangeStatusCertain(), start, PsiFactory.createRangeStatusCertain(), end);
    }

    public static RangeStatus createRangeStatus(String mi, String label) {
        return PsiFactory.createCvType(RangeStatus.class, mi, label);
    }

    public static RangeStatus createRangeStatusCertain() {
        return PsiFactory.createRangeStatus("MI:0335", "certain");
    }

    public static RangeStatus createRangeStatusNTerminal() {
        return PsiFactory.createRangeStatus("MI:0340", "n-terminal");
    }

    public static RangeStatus createRangeStatusCTerminal() {
        return PsiFactory.createRangeStatus("MI:0334", "c-terminal");
    }
}

