/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.xml.stylesheets;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.Writer;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import psidev.psi.mi.xml.stylesheets.XslTransformException;
import psidev.psi.mi.xml.util.PsimiXmlVersionDetector;

public class XslTransformerUtils {
    private static final String PSI_10_EXPAND = "/META-INF/stylesheets/v1_0/MIF_expand.xsl";
    private static final String PSI_10_COMPACT = "/META-INF/stylesheets/v1_0/MIF_compact.xsl";
    private static final String PSI_10_HTML = "/META-INF/stylesheets/v1_0/MIF_view.xsl";
    private static final String PSI_25_EXPAND = "/META-INF/stylesheets/v2_5/MIF25_expand.xsl";
    private static final String PSI_25_COMPACT = "/META-INF/stylesheets/v2_5/MIF25_compact.xsl";
    private static final String PSI_25_HTML = "/META-INF/stylesheets/v2_5/MIF25_view.xsl";
    private static final String PSI_254_EXPAND = "/META-INF/stylesheets/v2_5/MIF254_expand.xsl";
    private static final String PSI_254_COMPACT = "/META-INF/stylesheets/v2_5/MIF254_compact.xsl";
    private static final String PSI_254_HTML = "/META-INF/stylesheets/v2_5/MIF254_view.xsl";
    private static final String PSI_JSON = "/META-INF/stylesheets/v2_5/MIF25_json.xsl";
    private static final String NAMESPACE_FROM_254 = "http://psi.hupo.org/mi/mif";
    private static final String NAMESPACE_BEFORE_254 = "net:sf:psidev:mi";
    private static final URIResolver URI_RESOLVER = new CustomURIResolver("/META-INF/stylesheets/");

    private XslTransformerUtils() {
    }

    private static InputStream loadFromMetaInf(String resource) throws XslTransformException {
        try {
            return XslTransformerUtils.class.getResourceAsStream(resource);
        }
        catch (Exception e2) {
            throw new XslTransformException("An error occured while retrieving XSL located at: " + resource, e2);
        }
    }

    public static void runXslt(InputStream inputXml, InputStream xslt, OutputStream outputXml) throws XslTransformException {
        XslTransformerUtils.runXslt(new InputStreamReader(inputXml), xslt, new OutputStreamWriter(outputXml));
    }

    public static void runXslt(Reader inputReader, InputStream xslt, Writer outputWriter) throws XslTransformException {
        StreamSource xmlSource = new StreamSource(inputReader);
        StreamSource xsltSource = new StreamSource(xslt);
        TransformerFactory transFact = TransformerFactory.newInstance();
        transFact.setURIResolver(URI_RESOLVER);
        try {
            Transformer trans = transFact.newTransformer(xsltSource);
            trans.transform(xmlSource, new StreamResult(outputWriter));
        }
        catch (Exception e2) {
            throw new XslTransformException("An error occured while transforming the XML", e2);
        }
    }

    public static void expandPsiMi10(File inputXML, File outputXML) throws XslTransformException {
        XslTransformerUtils.checkFiles(inputXML, outputXML);
        try {
            XslTransformerUtils.expandPsiMi10(new FileInputStream(inputXML), new FileOutputStream(outputXML));
        }
        catch (FileNotFoundException e2) {
            throw new XslTransformException("Problem expanding file: " + inputXML, e2);
        }
    }

    public static void expandPsiMi10(InputStream inputXML, OutputStream outputXML) throws XslTransformException {
        XslTransformerUtils.transform(new PushbackReader(new InputStreamReader(inputXML)), outputXML, PSI_10_EXPAND);
    }

    public static void compactPsiMi10(File inputXML, File outputXML) throws XslTransformException {
        XslTransformerUtils.checkFiles(inputXML, outputXML);
        try {
            XslTransformerUtils.compactPsiMi10(new FileInputStream(inputXML), new FileOutputStream(outputXML));
        }
        catch (FileNotFoundException e2) {
            throw new XslTransformException("Problem compacting file: " + inputXML, e2);
        }
    }

    public static void compactPsiMi10(InputStream inputXML, OutputStream outputXML) throws XslTransformException {
        XslTransformerUtils.transform(new PushbackReader(new InputStreamReader(inputXML)), outputXML, PSI_10_COMPACT);
    }

    public static void viewPsiMi10(File inputXML, File outputXML) throws XslTransformException {
        XslTransformerUtils.checkFiles(inputXML, outputXML);
        try {
            XslTransformerUtils.viewPsiMi10(new FileInputStream(inputXML), new FileOutputStream(outputXML));
        }
        catch (FileNotFoundException e2) {
            throw new XslTransformException("Problem transforming file to HTML: " + inputXML, e2);
        }
    }

    public static void viewPsiMi10(InputStream inputXML, OutputStream outputXML) throws XslTransformException {
        XslTransformerUtils.transform(new PushbackReader(new InputStreamReader(inputXML)), outputXML, PSI_10_HTML);
    }

    public static void expandPsiMi25(File inputXML, File outputXML) throws XslTransformException {
        XslTransformerUtils.checkFiles(inputXML, outputXML);
        try {
            XslTransformerUtils.expandPsiMi25(new FileInputStream(inputXML), new FileOutputStream(outputXML));
        }
        catch (FileNotFoundException e2) {
            throw new XslTransformException("Problem expanding file: " + inputXML, e2);
        }
    }

    public static void expandPsiMi25(InputStream inputXML, OutputStream outputXML) throws XslTransformException {
        String xsl;
        PushbackReader pReader = new PushbackReader(new InputStreamReader(inputXML), 512);
        String namespace2 = XslTransformerUtils.detectNamespace(pReader);
        if (NAMESPACE_FROM_254.equals(namespace2)) {
            xsl = PSI_254_EXPAND;
        } else if (NAMESPACE_BEFORE_254.equals(namespace2)) {
            xsl = PSI_25_EXPAND;
        } else {
            throw new IllegalArgumentException("Namespace not supported: " + namespace2);
        }
        XslTransformerUtils.transform(pReader, outputXML, xsl);
    }

    public static void compactPsiMi25(File inputXML, File outputXML) throws XslTransformException {
        XslTransformerUtils.checkFiles(inputXML, outputXML);
        try {
            XslTransformerUtils.compactPsiMi25(new FileInputStream(inputXML), new FileOutputStream(outputXML));
        }
        catch (FileNotFoundException e2) {
            throw new XslTransformException("Problem compacting file: " + inputXML, e2);
        }
    }

    public static void compactPsiMi25(InputStream inputXML, OutputStream outputXML) throws XslTransformException {
        String xsl;
        PushbackReader pReader = new PushbackReader(new InputStreamReader(inputXML), 512);
        String namespace2 = XslTransformerUtils.detectNamespace(pReader);
        if (NAMESPACE_FROM_254.equals(namespace2)) {
            xsl = PSI_254_COMPACT;
        } else if (NAMESPACE_BEFORE_254.equals(namespace2)) {
            xsl = PSI_25_COMPACT;
        } else {
            throw new IllegalArgumentException("Namespace not supported: " + namespace2);
        }
        XslTransformerUtils.transform(pReader, outputXML, xsl);
    }

    public static void viewPsiMi25(File inputXML, File outputXML) throws XslTransformException {
        XslTransformerUtils.checkFiles(inputXML, outputXML);
        try {
            XslTransformerUtils.viewPsiMi25(new FileInputStream(inputXML), new FileOutputStream(outputXML));
        }
        catch (FileNotFoundException e2) {
            throw new XslTransformException("Problem transforming to HTML: " + inputXML, e2);
        }
    }

    public static void viewPsiMi25(InputStream inputXML, OutputStream outputXML) throws XslTransformException {
        String xsl;
        PushbackReader pReader = new PushbackReader(new InputStreamReader(inputXML), 512);
        String namespace2 = XslTransformerUtils.detectNamespace(pReader);
        if (NAMESPACE_FROM_254.equals(namespace2)) {
            xsl = PSI_254_HTML;
        } else if (NAMESPACE_BEFORE_254.equals(namespace2)) {
            xsl = PSI_25_HTML;
        } else {
            throw new IllegalArgumentException("Namespace not supported: " + namespace2);
        }
        XslTransformerUtils.transform(pReader, outputXML, xsl);
    }

    public static void jsonPsiMi(File inputXML, File outputXML) throws XslTransformException {
        XslTransformerUtils.checkFiles(inputXML, outputXML);
        try {
            XslTransformerUtils.jsonPsiMi(new FileInputStream(inputXML), new FileOutputStream(outputXML));
        }
        catch (FileNotFoundException e2) {
            throw new XslTransformException("Problem compacting file: " + inputXML, e2);
        }
    }

    public static void jsonPsiMi(InputStream inputXML, OutputStream outputXML) throws XslTransformException {
        PushbackReader pReader = new PushbackReader(new InputStreamReader(inputXML), 512);
        XslTransformerUtils.transform(pReader, outputXML, PSI_JSON);
    }

    private static void transform(PushbackReader pReader, OutputStream outputXML, String xsl) throws XslTransformException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputXML);
        XslTransformerUtils.runXslt(pReader, XslTransformerUtils.loadFromMetaInf(xsl), outputStreamWriter);
        try {
            outputStreamWriter.close();
        }
        catch (IOException e2) {
            throw new XslTransformException("Problem closing OutputStreamWriter", e2);
        }
    }

    private static void checkFiles(File inputXML, File outputXML) {
        if (inputXML == null) {
            throw new IllegalArgumentException("The given input file was null, Abort.");
        }
        if (outputXML == null) {
            throw new IllegalArgumentException("The given output file was null, Abort.");
        }
        if (!inputXML.exists()) {
            throw new IllegalArgumentException("The given input file didn't exist. Abort.");
        }
        if (outputXML.exists()) {
            throw new IllegalArgumentException("The given output file exist. Abort.");
        }
    }

    private static String detectNamespace(PushbackReader pReader) throws XslTransformException {
        PsimiXmlVersionDetector detector = new PsimiXmlVersionDetector();
        String namespace2 = null;
        try {
            namespace2 = detector.detectNamespace(pReader);
        }
        catch (IOException e2) {
            throw new XslTransformException("Problem reading stream", e2);
        }
        return namespace2;
    }

    private static class CustomURIResolver
    implements URIResolver {
        private String path;

        public CustomURIResolver(String path) {
            this.path = path;
        }

        public Source resolve(String href, String base) {
            InputStream inputStream = null;
            try {
                inputStream = XslTransformerUtils.loadFromMetaInf(this.path + href);
            }
            catch (XslTransformException e2) {
                e2.printStackTrace();
            }
            return new StreamSource(inputStream);
        }
    }
}

