/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.impl;

import cern.colt.Timer;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.doublealgo.Transform;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.impl.SparseDoubleMatrix2D;

class BenchmarkMatrix2D {
    protected BenchmarkMatrix2D() {
        throw new RuntimeException("Non instantiable");
    }

    public static void doubleBenchmark(int n, int n2, int n3, String string, boolean bl, int n4, double d, double d2) {
        int n5;
        int n6;
        int n7;
        System.out.println("benchmarking double matrix");
        Timer timer = new Timer();
        Timer timer2 = new Timer();
        Timer timer3 = new Timer();
        Timer timer4 = new Timer();
        Timer timer5 = new Timer();
        Timer timer6 = new Timer();
        timer5.start();
        int n8 = 0;
        int n9 = 0;
        while (n9 < n) {
            int n10 = 0;
            while (n10 < n3) {
                int n11 = 0;
                while (n11 < n2) {
                    ++n8;
                    ++n11;
                }
                ++n10;
            }
            ++n9;
        }
        timer5.stop();
        System.out.println(n8);
        timer6.start();
        n8 = 3;
        double d3 = 0.0;
        int n12 = 0;
        while (n12 < n) {
            boolean bl2 = false;
            int n13 = 0;
            while (n13 < n3) {
                int n14 = 0;
                while (n14 < n2) {
                    d3 += (double)n8;
                    ++n14;
                }
                ++n13;
            }
            ++n12;
        }
        timer6.stop();
        System.out.println(d3);
        long l = Runtime.getRuntime().freeMemory();
        long l2 = (long)n2 * (long)n3 * (long)n;
        DoubleMatrix2D doubleMatrix2D = null;
        if (string.equals("sparse")) {
            doubleMatrix2D = new SparseDoubleMatrix2D(n2, n3, n4, d, d2);
        } else if (string.equals("dense")) {
            doubleMatrix2D = new DenseDoubleMatrix2D(n2, n3);
        } else {
            throw new RuntimeException("unknown kind");
        }
        System.out.println("\nNow filling...");
        int n15 = 0;
        while (n15 < n) {
            doubleMatrix2D.assign(0.0);
            doubleMatrix2D.ensureCapacity(n4);
            if (string.equals("sparse")) {
                ((SparseDoubleMatrix2D)doubleMatrix2D).ensureCapacity(n4);
            }
            timer.start();
            int n16 = 0;
            int n17 = 0;
            while (n17 < n2) {
                int n18 = 0;
                while (n18 < n3) {
                    doubleMatrix2D.setQuick(n17, n18, n16++);
                    ++n18;
                }
                ++n17;
            }
            timer.stop();
            ++n15;
        }
        timer.display();
        timer.minus(timer5).display();
        System.out.println((float)l2 / timer.minus(timer5).seconds() + " elements / sec");
        Runtime.getRuntime().gc();
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        long l3 = Runtime.getRuntime().freeMemory();
        System.out.println("KB needed=" + (l - l3) / 1024L);
        System.out.println("bytes needed per non-zero=" + (double)(l - l3) / (double)doubleMatrix2D.cardinality());
        if (bl) {
            System.out.println(doubleMatrix2D);
            if (string.equals("sparse")) {
                System.out.println("map=" + ((SparseDoubleMatrix2D)doubleMatrix2D).elements);
            }
        }
        System.out.println("\nNow reading...");
        timer2.start();
        double d4 = 0.0;
        int n19 = 0;
        while (n19 < n) {
            int n20 = 0;
            while (n20 < n2) {
                n7 = 0;
                while (n7 < n3) {
                    d4 += doubleMatrix2D.getQuick(n20, n7);
                    ++n7;
                }
                ++n20;
            }
            ++n19;
        }
        timer2.stop().display();
        timer2.minus(timer6).display();
        System.out.println((float)l2 / timer2.minus(timer6).seconds() + " elements / sec");
        if (bl) {
            System.out.println(doubleMatrix2D);
        }
        System.out.println(d4);
        System.out.println("\nNow reading view...");
        DoubleMatrix2D doubleMatrix2D2 = doubleMatrix2D.viewPart(0, 0, n2, n3);
        timer4.start();
        d4 = 0.0;
        n7 = 0;
        while (n7 < n) {
            n6 = 0;
            while (n6 < n2) {
                n5 = 0;
                while (n5 < n3) {
                    d4 += doubleMatrix2D2.getQuick(n6, n5);
                    ++n5;
                }
                ++n6;
            }
            ++n7;
        }
        timer4.stop().display();
        timer4.minus(timer6).display();
        System.out.println((float)l2 / timer4.minus(timer6).seconds() + " elements / sec");
        if (bl) {
            System.out.println(doubleMatrix2D2);
        }
        System.out.println(d4);
        System.out.println("\nNow removing...");
        l = Runtime.getRuntime().freeMemory();
        n6 = 0;
        while (n6 < n) {
            int n21;
            n5 = 0;
            while (n5 < n2) {
                n21 = 0;
                while (n21 < n3) {
                    doubleMatrix2D.setQuick(n5, n21, 1.0);
                    ++n21;
                }
                ++n5;
            }
            timer3.start();
            n21 = 0;
            while (n21 < n2) {
                int n22 = 0;
                while (n22 < n3) {
                    doubleMatrix2D.setQuick(n21, n22, 0.0);
                    ++n22;
                }
                ++n21;
            }
            timer3.stop();
            ++n6;
        }
        timer3.display();
        timer3.minus(timer5).display();
        System.out.println((float)l2 / timer3.minus(timer5).seconds() + " elements / sec");
        Runtime.getRuntime().gc();
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        l3 = Runtime.getRuntime().freeMemory();
        System.out.println("KB needed=" + (l - l3) / 1024L);
        System.out.println("KB free=" + l3 / 1024L);
        if (bl) {
            System.out.println(doubleMatrix2D);
        }
        System.out.println("bye bye.");
    }

    public static void doubleBenchmarkMult(int n, int n2, int n3, String string, boolean bl, int n4, double d, double d2) {
        System.out.println("benchmarking double matrix");
        Timer timer = new Timer();
        Timer timer2 = new Timer();
        long l = (long)n2 * (long)n3 * (long)n;
        DoubleMatrix2D doubleMatrix2D = null;
        if (string.equals("sparse")) {
            doubleMatrix2D = new SparseDoubleMatrix2D(n2, n3, n4, d, d2);
        } else if (string.equals("dense")) {
            doubleMatrix2D = new DenseDoubleMatrix2D(n2, n3);
        } else {
            throw new RuntimeException("unknown kind");
        }
        System.out.println("\nNow multiplying...");
        doubleMatrix2D.assign(1.0);
        int n5 = 0;
        while (n5 < n) {
            timer.start();
            Transform.mult(doubleMatrix2D, 3.0);
            timer.stop();
            ++n5;
        }
        timer.display();
        System.out.println((float)l / timer.seconds() + " elements / sec");
        if (bl) {
            System.out.println(doubleMatrix2D);
        }
        System.out.println("\nNow multiplying2...");
        doubleMatrix2D.assign(1.0);
        int n6 = 0;
        while (n6 < n) {
            timer2.start();
            Transform.mult(doubleMatrix2D, 3.0);
            timer2.stop();
            ++n6;
        }
        timer2.display();
        System.out.println((float)l / timer2.seconds() + " elements / sec");
        if (bl) {
            System.out.println(doubleMatrix2D);
        }
        System.out.println("bye bye.");
    }

    public static void doubleBenchmarkPrimitive(int n, int n2, int n3, boolean bl) {
        int n4;
        Timer timer = new Timer();
        Timer timer2 = new Timer();
        Timer timer3 = new Timer();
        Timer timer4 = new Timer();
        Timer timer5 = new Timer();
        timer4.start();
        int n5 = 0;
        int n6 = 0;
        while (n6 < n) {
            int n7 = 0;
            while (n7 < n3) {
                int n8 = 0;
                while (n8 < n2) {
                    ++n5;
                    ++n8;
                }
                ++n7;
            }
            ++n6;
        }
        timer4.stop();
        System.out.println(n5);
        timer5.start();
        n5 = 3;
        double d = 0.0;
        int n9 = 0;
        while (n9 < n) {
            int n10 = 0;
            while (n10 < n3) {
                int n11 = 0;
                while (n11 < n2) {
                    d += (double)n5;
                    ++n11;
                }
                ++n10;
            }
            ++n9;
        }
        timer5.stop();
        System.out.println(d);
        long l = Runtime.getRuntime().freeMemory();
        long l2 = (long)n2 * (long)n3 * (long)n;
        double[][] dArray = new double[n2][n3];
        System.out.println("\nNow filling...");
        int n12 = 0;
        while (n12 < n) {
            timer.start();
            int n13 = 0;
            int n14 = 0;
            while (n14 < n3) {
                int n15 = 0;
                while (n15 < n2) {
                    dArray[n15][n14] = n13++;
                    ++n15;
                }
                ++n14;
            }
            timer.stop();
            ++n12;
        }
        timer.display();
        timer.minus(timer4).display();
        System.out.println((float)l2 / timer.minus(timer4).seconds() + " elements / sec");
        Runtime.getRuntime().gc();
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        long l3 = Runtime.getRuntime().freeMemory();
        System.out.println("KB needed=" + (l - l3) / 1024L);
        if (bl) {
            DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(n2, n3);
            denseDoubleMatrix2D.assign(dArray);
            System.out.println(denseDoubleMatrix2D);
        }
        System.out.println("\nNow reading...");
        timer2.start();
        double d2 = 0.0;
        int n16 = 0;
        while (n16 < n) {
            int n17 = 0;
            while (n17 < n3) {
                n4 = 0;
                while (n4 < n2) {
                    d2 += dArray[n4][n17];
                    ++n4;
                }
                ++n17;
            }
            ++n16;
        }
        timer2.stop().display();
        timer2.minus(timer5).display();
        System.out.println((float)l2 / timer2.minus(timer5).seconds() + " elements / sec");
        if (bl) {
            DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(n2, n3);
            denseDoubleMatrix2D.assign(dArray);
            System.out.println(denseDoubleMatrix2D);
        }
        System.out.println(d2);
        System.out.println("\nNow removing...");
        l = Runtime.getRuntime().freeMemory();
        int n18 = 0;
        while (n18 < n) {
            timer3.start();
            n4 = 0;
            while (n4 < n3) {
                int n19 = 0;
                while (n19 < n2) {
                    dArray[n19][n4] = 0.0;
                    ++n19;
                }
                ++n4;
            }
            timer3.stop();
            ++n18;
        }
        timer3.display();
        timer3.minus(timer4).display();
        System.out.println((float)l2 / timer3.minus(timer4).seconds() + " elements / sec");
        Runtime.getRuntime().gc();
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        l3 = Runtime.getRuntime().freeMemory();
        System.out.println("KB needed=" + (l - l3) / 1024L);
        System.out.println("KB free=" + l3 / 1024L);
        if (bl) {
            DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(n2, n3);
            denseDoubleMatrix2D.assign(dArray);
            System.out.println(denseDoubleMatrix2D);
        }
        System.out.println("bye bye.");
    }

    public static void doubleBenchmarkPrimitiveOptimized(int n, int n2, int n3, boolean bl) {
        Object object;
        Object object2;
        Timer timer = new Timer();
        Timer timer2 = new Timer();
        Timer timer3 = new Timer();
        Timer timer4 = new Timer();
        Timer timer5 = new Timer();
        timer4.start();
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            int n6 = 0;
            while (n6 < n3) {
                int n7 = 0;
                while (n7 < n2) {
                    ++n4;
                    ++n7;
                }
                ++n6;
            }
            ++n5;
        }
        timer4.stop();
        System.out.println(n4);
        timer5.start();
        n4 = 3;
        double d = 0.0;
        int n8 = 0;
        while (n8 < n) {
            int n9 = 0;
            while (n9 < n3) {
                int n10 = 0;
                while (n10 < n2) {
                    d += (double)n4;
                    ++n10;
                }
                ++n9;
            }
            ++n8;
        }
        timer5.stop();
        System.out.println(d);
        long l = Runtime.getRuntime().freeMemory();
        long l2 = (long)n2 * (long)n3 * (long)n;
        double[][] dArray = new double[n2][n3];
        System.out.println("\nNow filling...");
        int n11 = 0;
        while (n11 < n) {
            timer.start();
            int n12 = 0;
            int n13 = 0;
            while (n13 < n2) {
                object2 = dArray[n13];
                int n14 = 0;
                while (n14 < n3) {
                    object2[n14] = n12++;
                    ++n14;
                }
                ++n13;
            }
            timer.stop();
            ++n11;
        }
        timer.display();
        timer.minus(timer4).display();
        System.out.println((float)l2 / timer.minus(timer4).seconds() + " elements / sec");
        Runtime.getRuntime().gc();
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        long l3 = Runtime.getRuntime().freeMemory();
        System.out.println("KB needed=" + (l - l3) / 1024L);
        if (bl) {
            object2 = new DenseDoubleMatrix2D(n2, n3);
            ((DenseDoubleMatrix2D)object2).assign(dArray);
            System.out.println(object2);
        }
        System.out.println("\nNow reading...");
        timer2.start();
        double d2 = 0.0;
        int n15 = 0;
        while (n15 < n) {
            int n16 = 0;
            while (n16 < n2) {
                object = dArray[n16];
                int n17 = 0;
                while (n17 < n3) {
                    d2 += object[n17];
                    ++n17;
                }
                ++n16;
            }
            ++n15;
        }
        timer2.stop().display();
        timer2.minus(timer5).display();
        System.out.println((float)l2 / timer2.minus(timer5).seconds() + " elements / sec");
        if (bl) {
            DenseDoubleMatrix2D denseDoubleMatrix2D = new DenseDoubleMatrix2D(n2, n3);
            denseDoubleMatrix2D.assign(dArray);
            System.out.println(denseDoubleMatrix2D);
        }
        System.out.println(d2);
        System.out.println("\nNow removing...");
        l = Runtime.getRuntime().freeMemory();
        int n18 = 0;
        while (n18 < n) {
            timer3.start();
            int n19 = 0;
            while (n19 < n2) {
                double[] dArray2 = dArray[n19];
                int n20 = 0;
                while (n20 < n3) {
                    dArray2[n20] = 0.0;
                    ++n20;
                }
                ++n19;
            }
            timer3.stop();
            ++n18;
        }
        timer3.display();
        timer3.minus(timer4).display();
        System.out.println((float)l2 / timer3.minus(timer4).seconds() + " elements / sec");
        Runtime.getRuntime().gc();
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        l3 = Runtime.getRuntime().freeMemory();
        System.out.println("KB needed=" + (l - l3) / 1024L);
        System.out.println("KB free=" + l3 / 1024L);
        if (bl) {
            object = new DenseDoubleMatrix2D(n2, n3);
            ((DenseDoubleMatrix2D)object).assign(dArray);
            System.out.println(object);
        }
        System.out.println("bye bye.");
    }

    public static void intBenchmark(int n, int n2, int n3, String string, boolean bl, int n4, double d, double d2) {
        throw new InternalError();
    }

    public static void intBenchmarkPrimitive(int n, int n2, int n3, boolean bl) {
        throw new InternalError();
    }

    public static void intBenchmarkPrimitiveOptimized(int n, int n2, int n3, boolean bl) {
        throw new InternalError();
    }

    public static void main(String[] stringArray) {
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        int n3 = Integer.parseInt(stringArray[2]);
        String string = stringArray[3];
        int n4 = Integer.parseInt(stringArray[4]);
        double d = new Double(stringArray[5]);
        double d2 = new Double(stringArray[6]);
        boolean bl = stringArray[7].equals("print");
        String string2 = stringArray[8];
        String string3 = stringArray[9];
        if (string2.equals("int")) {
            if (string.equals("primitive")) {
                BenchmarkMatrix2D.intBenchmarkPrimitive(n, n2, n3, bl);
            } else if (string.equals("primitiveOpt")) {
                BenchmarkMatrix2D.intBenchmarkPrimitiveOptimized(n, n2, n3, bl);
            } else {
                BenchmarkMatrix2D.intBenchmark(n, n2, n3, string, bl, n4, d, d2);
            }
        } else if (string2.equals("double")) {
            if (string.equals("primitive")) {
                BenchmarkMatrix2D.doubleBenchmarkPrimitive(n, n2, n3, bl);
            } else if (string.equals("primitiveOpt")) {
                BenchmarkMatrix2D.doubleBenchmarkPrimitiveOptimized(n, n2, n3, bl);
            } else if (string3.equals("mult")) {
                BenchmarkMatrix2D.doubleBenchmarkMult(n, n2, n3, string, bl, n4, d, d2);
            } else {
                BenchmarkMatrix2D.doubleBenchmark(n, n2, n3, string, bl, n4, d, d2);
            }
        }
    }
}

