/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random;

import cern.jet.math.Arithmetic;
import cern.jet.random.AbstractDiscreteDistribution;
import cern.jet.random.AbstractDistribution;
import cern.jet.stat.Probability;
import edu.cornell.lassp.houle.RngPack.RandomElement;

public class Poisson
extends AbstractDiscreteDistribution {
    protected double mean;
    protected double my_old = -1.0;
    protected double p;
    protected double q;
    protected double p0;
    protected double[] pp = new double[36];
    protected int llll;
    protected double my_last = -1.0;
    protected double ll;
    protected int k2;
    protected int k4;
    protected int k1;
    protected int k5;
    protected double dl;
    protected double dr;
    protected double r1;
    protected double r2;
    protected double r4;
    protected double r5;
    protected double lr;
    protected double l_my;
    protected double c_pm;
    protected double f1;
    protected double f2;
    protected double f4;
    protected double f5;
    protected double p1;
    protected double p2;
    protected double p3;
    protected double p4;
    protected double p5;
    protected double p6;
    protected int m;
    protected static final double MEAN_MAX = 2.147483647E9;
    protected static final double SWITCH_MEAN = 10.0;
    protected static Poisson shared = new Poisson(0.0, AbstractDistribution.makeDefaultGenerator());

    public Poisson(double d, RandomElement randomElement) {
        this.setRandomGenerator(randomElement);
        this.setMean(d);
    }

    public double cdf(int n) {
        return Probability.poisson(n, this.mean);
    }

    public Object clone() {
        Poisson poisson = (Poisson)super.clone();
        if (this.pp != null) {
            poisson.pp = (double[])this.pp.clone();
        }
        return poisson;
    }

    private static double f(int n, double d, double d2) {
        return Math.exp((double)n * d - Arithmetic.logFactorial(n) - d2);
    }

    public int nextInt() {
        return this.nextInt(this.mean);
    }

    public int nextInt(double d) {
        RandomElement randomElement = this.randomGenerator;
        double d2 = d;
        if (d2 < 10.0) {
            if (d2 != this.my_old) {
                this.my_old = d2;
                this.m = d2 > 1.0 ? (int)d2 : 1;
                this.llll = 0;
                this.q = this.p = Math.exp(-d2);
                this.p0 = this.p;
            }
            while (true) {
                double d3 = randomElement.raw();
                int n = 0;
                if (d3 <= this.p0) {
                    return n;
                }
                if (this.llll != 0) {
                    int n2;
                    n = n2 = d3 > 0.458 ? Math.min(this.llll, this.m) : 1;
                    while (n <= this.llll) {
                        if (d3 <= this.pp[n]) {
                            return n;
                        }
                        ++n;
                    }
                    if (this.llll == 35) continue;
                }
                n = this.llll + 1;
                while (n <= 35) {
                    this.p *= d2 / (double)n;
                    this.q += this.p;
                    this.pp[n] = this.q;
                    if (d3 <= this.q) {
                        this.llll = n;
                        return n;
                    }
                    ++n;
                }
                this.llll = 35;
            }
        }
        if (d2 < 2.147483647E9) {
            int n;
            if (d2 != this.my_last) {
                this.my_last = d2;
                double d4 = Math.sqrt(d2 + 0.25);
                this.m = (int)d2;
                this.k2 = (int)Math.ceil(d2 - 0.5 - d4);
                this.k4 = (int)(d2 - 0.5 + d4);
                this.k1 = this.k2 + this.k2 - this.m + 1;
                this.k5 = this.k4 + this.k4 - this.m;
                this.dl = this.k2 - this.k1;
                this.dr = this.k5 - this.k4;
                this.r1 = d2 / (double)this.k1;
                this.r2 = d2 / (double)this.k2;
                this.r4 = d2 / (double)(this.k4 + 1);
                this.r5 = d2 / (double)(this.k5 + 1);
                this.ll = Math.log(this.r1);
                this.lr = -Math.log(this.r5);
                this.l_my = Math.log(d2);
                this.c_pm = (double)this.m * this.l_my - Arithmetic.logFactorial(this.m);
                this.f2 = Poisson.f(this.k2, this.l_my, this.c_pm);
                this.f4 = Poisson.f(this.k4, this.l_my, this.c_pm);
                this.f1 = Poisson.f(this.k1, this.l_my, this.c_pm);
                this.f5 = Poisson.f(this.k5, this.l_my, this.c_pm);
                this.p1 = this.f2 * (this.dl + 1.0);
                this.p2 = this.f2 * this.dl + this.p1;
                this.p3 = this.f4 * (this.dr + 1.0) + this.p2;
                this.p4 = this.f4 * this.dr + this.p3;
                this.p5 = this.f1 / this.ll + this.p4;
                this.p6 = this.f5 / this.lr + this.p5;
            }
            while (true) {
                int n3;
                int n4;
                double d5;
                double d6;
                double d7;
                double d8 = randomElement.raw() * this.p6;
                if (d7 < this.p2) {
                    double d9;
                    double d10;
                    double d11;
                    d6 = d8 - this.p1;
                    if (d11 < 0.0) {
                        return this.k2 + (int)(d8 / this.f2);
                    }
                    d5 = d6 / this.dl;
                    if (d10 < this.f1) {
                        return this.k1 + (int)(d6 / this.f1);
                    }
                    n4 = (int)(this.dl * randomElement.raw()) + 1;
                    if (d5 <= this.f2 - (double)n4 * (this.f2 - this.f2 / this.r2)) {
                        return this.k2 - n4;
                    }
                    d6 = this.f2 + this.f2 - d5;
                    if (d9 < 1.0) {
                        n3 = this.k2 + n4;
                        if (d6 <= this.f2 + (double)n4 * (1.0 - this.f2) / (this.dl + 1.0)) {
                            return n3;
                        }
                        if (d6 <= Poisson.f(n3, this.l_my, this.c_pm)) {
                            return n3;
                        }
                    }
                    n = this.k2 - n4;
                } else if (d8 < this.p4) {
                    double d12;
                    double d13;
                    double d14;
                    d6 = d8 - this.p3;
                    if (d14 < 0.0) {
                        return this.k4 - (int)((d8 - this.p2) / this.f4);
                    }
                    d5 = d6 / this.dr;
                    if (d13 < this.f5) {
                        return this.k5 - (int)(d6 / this.f5);
                    }
                    n4 = (int)(this.dr * randomElement.raw()) + 1;
                    if (d5 <= this.f4 - (double)n4 * (this.f4 - this.f4 * this.r4)) {
                        return this.k4 + n4;
                    }
                    d6 = this.f4 + this.f4 - d5;
                    if (d12 < 1.0) {
                        n3 = this.k4 - n4;
                        if (d6 <= this.f4 + (double)n4 * (1.0 - this.f4) / this.dr) {
                            return n3;
                        }
                        if (d6 <= Poisson.f(n3, this.l_my, this.c_pm)) {
                            return n3;
                        }
                    }
                    n = this.k4 + n4;
                } else {
                    d5 = randomElement.raw();
                    if (d8 < this.p5) {
                        n4 = (int)(1.0 - Math.log(d5) / this.ll);
                        n = this.k1 - n4;
                        if (n < 0) continue;
                        if ((d5 *= (d8 - this.p4) * this.ll) <= this.f1 - (double)n4 * (this.f1 - this.f1 / this.r1)) {
                            return n;
                        }
                    } else {
                        n4 = (int)(1.0 - Math.log(d5) / this.lr);
                        n = this.k5 + n4;
                        if ((d5 *= (d8 - this.p5) * this.lr) <= this.f5 - (double)n4 * (this.f5 - this.f5 * this.r5)) {
                            return n;
                        }
                    }
                }
                if (Math.log(d5) <= (double)n * this.l_my - Arithmetic.logFactorial(n) - this.c_pm) break;
            }
            return n;
        }
        return (int)d2;
    }

    public double pdf(int n) {
        return Math.exp((double)n * Math.log(this.mean) - Arithmetic.logFactorial(n) - this.mean);
    }

    public void setMean(double d) {
        this.mean = d;
    }

    public static int staticNextInt(double d) {
        Poisson poisson = shared;
        synchronized (poisson) {
            shared.setMean(d);
            int n = shared.nextInt();
            return n;
        }
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.mean + ")";
    }

    private static void xstaticSetRandomGenerator(RandomElement randomElement) {
        Poisson poisson = shared;
        synchronized (poisson) {
            shared.setRandomGenerator(randomElement);
        }
    }
}

