/*
 * Decompiled with CFR 0.152.
 */
package eponine.model;

import eponine.model.DiscreteDistribution;

public class GaussianDistribution
implements DiscreteDistribution {
    private static final double INF = 3.5;
    private double width;
    private int intWidth;
    private double[] values;

    public GaussianDistribution(double d) {
        this.width = d;
        this.intWidth = (int)Math.ceil(d * 3.5);
        this.values = new double[this.intWidth + 1];
        double d2 = 0.0;
        int n = 0;
        while (n <= this.intWidth) {
            double d3 = GaussianDistribution.distrib(d, (double)n - 0.5);
            double d4 = GaussianDistribution.distrib(d, n);
            double d5 = GaussianDistribution.distrib(d, (double)n + 0.5);
            this.values[n] = (d3 + 2.0 * d4 + d5) / 4.0;
            d2 = n == 0 ? (d2 += this.values[n]) : (d2 += this.values[n] * 2.0);
            ++n;
        }
        int n2 = 0;
        while (n2 <= this.intWidth) {
            this.values[n2] = this.values[n2] / d2;
            ++n2;
        }
    }

    public double getWidth() {
        return this.width;
    }

    public int getMin() {
        return -this.intWidth;
    }

    public int getMax() {
        return this.intWidth;
    }

    public double probability(int n) {
        if ((n = Math.abs(n)) > this.intWidth) {
            return 0.0;
        }
        return this.values[n];
    }

    public double probabilityDivMax(int n) {
        return this.probability(n) / this.probability(0);
    }

    public int hashCode() {
        return (int)(this.width * 100000.0);
    }

    public boolean equals(Object object) {
        if (!(object instanceof GaussianDistribution)) {
            return false;
        }
        GaussianDistribution gaussianDistribution = (GaussianDistribution)object;
        return gaussianDistribution.getWidth() == this.width;
    }

    private static double distrib(double d, double d2) {
        double d3 = d2 / d;
        return 0.15915494309189535 * Math.exp(-d3 * d3 / 2.0);
    }

    public static void main(String[] stringArray) {
        GaussianDistribution gaussianDistribution = new GaussianDistribution(2.0);
        int n = gaussianDistribution.getMin();
        while (n <= gaussianDistribution.getMax()) {
            System.out.println(n + " " + gaussianDistribution.probability(n));
            ++n;
        }
    }
}

