/*
 * Decompiled with CFR 0.152.
 */
package jal.INT;

import jal.INT.BinaryOperator;

public final class Numeric {
    public static int accumulate(int[] nArray, int n, int n2, int n3) {
        int n4 = n3;
        while (n < n2) {
            n4 += nArray[n++];
        }
        return n4;
    }

    public static int accumulate(int[] nArray, int n, int n2, int n3, BinaryOperator binaryOperator) {
        int n4 = n3;
        while (n < n2) {
            n4 = binaryOperator.apply(n4, nArray[n++]);
        }
        return n4;
    }

    public static int inner_product(int[] nArray, int[] nArray2, int n, int n2, int n3, int n4) {
        int n5 = n4;
        while (n < n2) {
            n5 += nArray[n++] * nArray2[n3++];
        }
        return n5;
    }

    public static int inner_product(int[] nArray, int[] nArray2, int n, int n2, int n3, int n4, BinaryOperator binaryOperator, BinaryOperator binaryOperator2) {
        int n5 = n4;
        while (n < n2) {
            n5 = binaryOperator.apply(n5, binaryOperator2.apply(nArray[n++], nArray2[n3++]));
        }
        return n5;
    }

    public static int partial_sum(int[] nArray, int[] nArray2, int n, int n2, int n3) {
        if (n < n2) {
            nArray2[n3] = nArray[n];
            int n4 = nArray2[n3];
            while (++n < n2) {
                nArray2[++n3] = n4 += nArray[n];
            }
            return n3 + 1;
        }
        return n3;
    }

    public static int partial_sum(int[] nArray, int[] nArray2, int n, int n2, int n3, BinaryOperator binaryOperator) {
        if (n < n2) {
            nArray2[n3] = nArray[n];
            int n4 = nArray2[n3];
            while (++n < n2) {
                n4 = binaryOperator.apply(n4, nArray[n]);
                nArray2[++n3] = n4;
            }
            return n3 + 1;
        }
        return n3;
    }

    public static int adjacent_difference(int[] nArray, int[] nArray2, int n, int n2, int n3) {
        if (n < n2) {
            nArray2[n3] = nArray[n];
            int n4 = nArray[n];
            while (++n < n2) {
                int n5 = nArray[n];
                nArray2[++n3] = n5 - n4;
                n4 = n5;
            }
            return n3 + 1;
        }
        return n3;
    }

    public static int adjacent_difference(int[] nArray, int[] nArray2, int n, int n2, int n3, BinaryOperator binaryOperator) {
        if (n < n2) {
            nArray2[n3] = nArray[n];
            int n4 = nArray[n];
            while (++n < n2) {
                int n5 = nArray[n];
                nArray2[++n3] = binaryOperator.apply(n5, n4);
                n4 = n5;
            }
            return n3 + 1;
        }
        return n3;
    }

    private Numeric() {
    }
}

