/*
 * Decompiled with CFR 0.152.
 */
package org.acedb.socket;

import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.acedb.AceError;
import org.acedb.AceException;
import org.acedb.AceNode;
import org.acedb.AcePerlParser;
import org.acedb.AceSet;
import org.acedb.AceURL;
import org.acedb.AceUtils;
import org.acedb.Connection;
import org.acedb.Database;
import org.acedb.socket.AceSocket;
import org.acedb.socket.SocketClazzSet;
import org.acedb.socket.SocketResultSet;
import org.acedb.staticobj.StaticAceSet;

class SocketDatabase
implements Database {
    private List socks = new LinkedList();
    private AceURL dbURL;
    private String host;
    private int port;
    private String user;
    private String passwd;
    private AcePerlParser parser;
    private Map cache = new HashMap();
    private AceSet allClassesSet = null;

    public SocketDatabase(AceURL aceURL) throws AceException {
        this.parser = new AcePerlParser(this);
        this.dbURL = aceURL;
        this.host = aceURL.getHost();
        this.port = aceURL.getPort();
        this.user = aceURL.getUserInfo();
        this.passwd = aceURL.getAuthority();
        AceSocket aceSocket = this.takeSocket();
        this.putSocket(aceSocket);
    }

    private AceSet _allClasses() throws AceException {
        if (this.allClassesSet == null) {
            AceSocket aceSocket = null;
            try {
                aceSocket = this.takeSocket();
                String string = aceSocket.transact("classes");
                StaticAceSet staticAceSet = new StaticAceSet(null, this.dbURL, null);
                StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    if (string2.charAt(0) > ' ') continue;
                    StringTokenizer stringTokenizer2 = new StringTokenizer(string2);
                    String string3 = stringTokenizer2.nextToken().trim();
                    staticAceSet.add(string3, new SocketClazzSet(string3, this.dbURL.relativeURL(String.valueOf(string3) + '/'), staticAceSet, this));
                }
                this.allClassesSet = staticAceSet;
            }
            finally {
                Object var3_8 = null;
                if (aceSocket != null) {
                    this.putSocket(aceSocket);
                }
            }
        }
        return this.allClassesSet;
    }

    private AceNode _getObject(String string, String string2) throws AceException {
        if (string == null) {
            throw new NullPointerException("Class name was null");
        }
        String string3 = String.valueOf(string) + ":" + string2;
        AceNode aceNode = this.getFromCache(string3);
        if (aceNode != null) {
            return aceNode;
        }
        AceSocket aceSocket = null;
        try {
            aceSocket = this.takeSocket();
            String string4 = "find " + AceUtils.decode(string) + " " + AceUtils.decode(string2);
            String string5 = aceSocket.transact(string4);
            String string6 = "// Found ";
            int n = string5.indexOf(string6) + string6.length();
            int n2 = string5.indexOf(" ", n);
            String string7 = string5.substring(n, n2);
            try {
                int n3 = Integer.parseInt(string5.substring(n, n2));
                if (n3 == 0) {
                    throw new AceException("Couldn't find object " + string3 + " using query " + string4 + " - does it exist?");
                }
                if (n3 > 1) {
                    throw new AceException("Found multiple objects (" + n3 + ") with " + string3 + " using query " + string4);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new AceError("Couldn't parse string '" + string7 + "' at index " + n + " to " + n2);
            }
            String string8 = aceSocket.transact("show -p");
            aceNode = this.parser.parseObject(string8);
        }
        finally {
            Object var7_14 = null;
            if (aceSocket != null) {
                this.putSocket(aceSocket);
            }
        }
        this.cacheObject(string3, aceNode);
        return aceNode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private AceSet _select(String string, String string2) throws AceException {
        SocketResultSet socketResultSet;
        AceSocket aceSocket = null;
        try {
            aceSocket = this.takeSocket();
            String string3 = string;
            string3 = AceUtils.decode(string);
            String string4 = aceSocket.transact("find " + string3 + " " + string2);
            int n = string4.indexOf("// Found ");
            if (n < 0) {
                AceSet aceSet = null;
                Object var6_9 = null;
                if (aceSocket == null) return aceSet;
                this.putSocket(aceSocket);
                return aceSet;
            }
            int n2 = Integer.parseInt(new StringTokenizer(string4.substring(n + 9)).nextToken());
            System.out.println("found " + n2);
            string4 = aceSocket.transact("list -j");
            StringTokenizer stringTokenizer = new StringTokenizer(string4, "\r\n");
            ArrayList<String> arrayList = new ArrayList<String>();
            while (stringTokenizer.hasMoreTokens()) {
                String string5 = stringTokenizer.nextToken();
                AceUtils.encode(string5);
                if (!string5.startsWith("?") || !string5.endsWith("?")) continue;
                int n3 = string5.indexOf("?", 1);
                String string6 = string5.substring(1, n3);
                String string7 = string5.substring(n3 + 1, string5.length() - 1);
                if (string7.startsWith("\\?")) {
                    string7 = string7.substring(1);
                }
                string7 = AceUtils.encode(string7);
                arrayList.add(string7);
            }
            socketResultSet = new SocketResultSet(this, this.allClasses().retrieve(string), arrayList, this.dbURL.relativeURL(String.valueOf(string) + '?' + string2));
        }
        catch (Throwable throwable) {
            Object var6_11 = null;
            if (aceSocket == null) throw throwable;
            this.putSocket(aceSocket);
            throw throwable;
        }
        Object var6_10 = null;
        if (aceSocket == null) return socketResultSet;
        this.putSocket(aceSocket);
        return socketResultSet;
    }

    private AceSet allClasses() throws AceException {
        AceSet aceSet = null;
        while (aceSet == null) {
            try {
                aceSet = this._allClasses();
            }
            catch (AceException aceException) {
                aceException.printStackTrace();
                if (aceException.isRecoverable()) continue;
                throw aceException;
            }
        }
        return aceSet;
    }

    private synchronized void cacheObject(String string, AceNode aceNode) {
        this.cache.put(string, new SoftReference<AceNode>(aceNode));
    }

    public AceSet fetch(AceURL aceURL) throws AceException {
        String string;
        AceSet aceSet = null;
        String string2 = aceURL.getFile();
        string2 = string2 == null ? "" : string2;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "/");
        if (stringTokenizer.countTokens() == 0) {
            return this.allClasses();
        }
        if (stringTokenizer.countTokens() == 1) {
            string = stringTokenizer.nextToken();
            aceSet = this.allClasses().retrieve(string);
        } else {
            string = stringTokenizer.nextToken();
            if (string == null) {
                throw new AceException("Couldn't extract class name from URL " + string2);
            }
            String string3 = stringTokenizer.nextToken();
            if (string3 == null) {
                throw new AceException("Couldn't extract class name from URL " + string2);
            }
            aceSet = this.getObject(string, string3);
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                aceSet = aceSet.retrieve(string4);
            }
        }
        string = aceURL.getQuery();
        if (string != null && string.length() != 0) {
            aceSet = aceSet.filter(string);
        }
        return aceSet;
    }

    public Connection getConnection() throws AceException {
        return new ConnectionProxy();
    }

    private synchronized AceNode getFromCache(String string) {
        SoftReference softReference = (SoftReference)this.cache.get(string);
        if (softReference != null) {
            AceNode aceNode = (AceNode)softReference.get();
            if (aceNode != null) {
                return aceNode;
            }
            this.cache.remove(string);
        }
        return null;
    }

    public AceNode getObject(String string, String string2) throws AceException {
        AceNode aceNode = null;
        while (aceNode == null) {
            try {
                aceNode = this._getObject(string, string2);
            }
            catch (AceException aceException) {
                aceException.printStackTrace();
                if (aceException.isRecoverable()) continue;
                throw aceException;
            }
        }
        return aceNode;
    }

    synchronized void putSocket(AceSocket aceSocket) {
        if (aceSocket == null) {
            throw new AceError("Attemted to add a null socket");
        }
        if (!aceSocket.isDefunct()) {
            this.socks.add(aceSocket);
        }
    }

    AceSet select(String string, String string2) throws AceException {
        AceSet aceSet = null;
        while (aceSet == null) {
            try {
                aceSet = this._select(string, string2);
            }
            catch (AceException aceException) {
                aceException.printStackTrace();
                if (aceException.isRecoverable()) continue;
                throw aceException;
            }
        }
        return aceSet;
    }

    synchronized AceSocket takeSocket() throws AceException {
        AceSocket aceSocket = null;
        if (this.socks.size() > 0) {
            aceSocket = (AceSocket)this.socks.remove(0);
        }
        if (aceSocket == null) {
            aceSocket = new AceSocket(this.host, this.port, this.user, this.passwd);
        }
        return aceSocket;
    }

    public AceURL toURL() {
        return this.dbURL;
    }

    class ConnectionProxy
    implements Connection {
        private AceSocket sock;

        ConnectionProxy() throws AceException {
            this.sock = SocketDatabase.this.takeSocket();
        }

        public void dispose() throws AceException {
            SocketDatabase.this.putSocket(this.sock);
            this.sock = null;
        }

        public void finalize() throws IOException {
            SocketDatabase.this.putSocket(this.sock);
            this.sock = null;
        }

        public String transact(String string) throws AceException {
            return this.sock.transact(string);
        }
    }
}

