/*
 * Decompiled with CFR 0.152.
 */
package org.acedb.staticobj;

import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.acedb.AceException;
import org.acedb.AceNode;
import org.acedb.AceSet;
import org.acedb.AceURL;
import org.acedb.AceURLException;

public class StaticAceNode
implements AceNode {
    private Map subSets;
    private AceSet parent;
    private String name;

    public StaticAceNode(String string, Map map, AceSet aceSet) {
        this.name = string;
        this.subSets = map;
        this.parent = aceSet;
    }

    public StaticAceNode(String string, AceSet aceSet) {
        this.name = string;
        this.parent = aceSet;
        this.subSets = null;
    }

    public void addNode(AceNode aceNode) {
        if (this.subSets == null) {
            this.subSets = new HashMap();
        }
        this.subSets.put(aceNode.getName(), aceNode);
    }

    public boolean contains(String string) {
        if (this.subSets != null) {
            return this.subSets.containsKey(string);
        }
        return false;
    }

    public AceSet filter(String string) {
        throw new UnsupportedOperationException("Haven't implemented filtering of nodes yet");
    }

    public String getName() {
        return this.name;
    }

    public AceSet getParent() {
        return this.parent;
    }

    public Iterator iterator() {
        if (this.subSets != null) {
            return this.subSets.values().iterator();
        }
        return Collections.EMPTY_SET.iterator();
    }

    public Iterator nameIterator() {
        if (this.subSets != null) {
            return this.subSets.keySet().iterator();
        }
        return Collections.EMPTY_SET.iterator();
    }

    public AceSet retrieve(String string) throws AceException {
        AceSet aceSet = null;
        if (this.subSets != null) {
            aceSet = (AceSet)this.subSets.get(string);
        }
        if (aceSet == null) {
            throw new AceException("Could not find child with the name '" + string + "'" + " in object " + this.getName());
        }
        return aceSet;
    }

    public int size() {
        if (this.subSets != null) {
            return this.subSets.size();
        }
        return 0;
    }

    public AceURL toURL() throws AceURLException {
        return this.parent.toURL().relativeURL(URLEncoder.encode(this.name));
    }
}

