/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dist;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.biojava.bio.dist.AbstractOrderNDistribution;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.DistributionFactory;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;

class GeneralNthOrderDistribution
extends AbstractOrderNDistribution {
    private Map dists = new HashMap();

    GeneralNthOrderDistribution(Alphabet alphabet, DistributionFactory distributionFactory) throws IllegalAlphabetException {
        super(alphabet);
        Iterator iterator = ((FiniteAlphabet)this.getConditioningAlphabet()).iterator();
        while (iterator.hasNext()) {
            Symbol symbol = (Symbol)iterator.next();
            this.dists.put(symbol, distributionFactory.createDistribution(this.getConditionedAlphabet()));
        }
    }

    public Collection conditionedDistributions() {
        return this.dists.values();
    }

    public Distribution getDistribution(Symbol symbol) throws IllegalSymbolException {
        Distribution distribution = (Distribution)this.dists.get(symbol);
        if (distribution == null) {
            this.getConditioningAlphabet().validate(symbol);
        }
        return distribution;
    }

    public void setDistribution(Symbol symbol, Distribution distribution) throws IllegalSymbolException, IllegalAlphabetException {
        this.getConditioningAlphabet().validate(symbol);
        if (distribution.getAlphabet() != this.getConditionedAlphabet()) {
            throw new IllegalAlphabetException("The distribution must be over " + this.getConditionedAlphabet() + ", not " + distribution.getAlphabet());
        }
        Distribution distribution2 = (Distribution)this.dists.get(symbol);
        if (distribution2 != null && this.weightForwarder != null) {
            distribution2.removeChangeListener(this.weightForwarder);
        }
        if (this.weightForwarder != null) {
            distribution.addChangeListener(this.weightForwarder);
        }
        this.dists.put(symbol, distribution);
    }
}

