/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dist;

import org.biojava.bio.BioError;
import org.biojava.bio.dist.Count;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AlphabetIndex;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public class IndexedCount
implements Count {
    private final AlphabetIndex indexer;
    private final double[] counts;
    protected transient ChangeSupport changeSupport = null;

    public IndexedCount(AlphabetIndex alphabetIndex) {
        alphabetIndex.addChangeListener(ChangeListener.ALWAYS_VETO, AlphabetIndex.INDEX);
        this.indexer = alphabetIndex;
        this.counts = new double[alphabetIndex.getAlphabet().size()];
    }

    public IndexedCount(FiniteAlphabet finiteAlphabet) {
        this(AlphabetManager.getAlphabetIndex(finiteAlphabet));
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.createChangeSupport(null);
        ChangeSupport changeSupport = this.changeSupport;
        synchronized (changeSupport) {
            this.changeSupport.addChangeListener(changeListener);
        }
    }

    public void addChangeListener(ChangeListener changeListener, ChangeType changeType) {
        this.createChangeSupport(changeType);
        ChangeSupport changeSupport = this.changeSupport;
        synchronized (changeSupport) {
            this.changeSupport.addChangeListener(changeListener, changeType);
        }
    }

    protected void createChangeSupport(ChangeType changeType) {
        if (this.changeSupport == null) {
            this.changeSupport = new ChangeSupport();
        }
    }

    public Alphabet getAlphabet() {
        return this.indexer.getAlphabet();
    }

    public double getCount(AtomicSymbol atomicSymbol) throws IllegalSymbolException {
        return this.counts[this.indexer.indexForSymbol(atomicSymbol)];
    }

    public void increaseCount(AtomicSymbol atomicSymbol, double d) throws IllegalSymbolException, ChangeVetoException {
        if (this.changeSupport == null) {
            int n = this.indexer.indexForSymbol(atomicSymbol);
            this.counts[n] = this.counts[n] + d;
        } else {
            ChangeSupport changeSupport = this.changeSupport;
            synchronized (changeSupport) {
                int n = this.indexer.indexForSymbol(atomicSymbol);
                double d2 = this.counts[n];
                double d3 = d2 + d;
                ChangeEvent changeEvent = new ChangeEvent(this, Count.COUNTS, new Object[]{atomicSymbol, new Double(d2)}, new Object[]{atomicSymbol, new Double(d3)});
                this.changeSupport.firePreChangeEvent(changeEvent);
                this.counts[n] = d3;
                this.changeSupport.firePostChangeEvent(changeEvent);
            }
        }
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.createChangeSupport(null);
        ChangeSupport changeSupport = this.changeSupport;
        synchronized (changeSupport) {
            this.changeSupport.removeChangeListener(changeListener);
        }
    }

    public void removeChangeListener(ChangeListener changeListener, ChangeType changeType) {
        this.createChangeSupport(changeType);
        ChangeSupport changeSupport = this.changeSupport;
        synchronized (changeSupport) {
            this.changeSupport.removeChangeListener(changeListener, changeType);
        }
    }

    public void setCount(AtomicSymbol atomicSymbol, double d) throws IllegalSymbolException, ChangeVetoException {
        if (this.changeSupport == null) {
            this.counts[this.indexer.indexForSymbol((Symbol)atomicSymbol)] = d;
        } else {
            ChangeSupport changeSupport = this.changeSupport;
            synchronized (changeSupport) {
                int n = this.indexer.indexForSymbol(atomicSymbol);
                ChangeEvent changeEvent = new ChangeEvent(this, Count.COUNTS, new Object[]{atomicSymbol, new Double(this.counts[n])}, new Object[]{atomicSymbol, new Double(d)});
                this.changeSupport.firePreChangeEvent(changeEvent);
                this.counts[n] = d;
                this.changeSupport.firePostChangeEvent(changeEvent);
            }
        }
    }

    public void setCounts(Count count) throws IllegalAlphabetException, ChangeVetoException {
        block9: {
            if (count.getAlphabet() != this.getAlphabet()) {
                throw new IllegalAlphabetException("Alphabet must match: " + count.getAlphabet().getName() + " != " + count.getAlphabet().getName());
            }
            try {
                if (this.changeSupport == null) {
                    int n = 0;
                    while (n < this.counts.length) {
                        this.counts[n] = count.getCount((AtomicSymbol)this.indexer.symbolForIndex(n));
                        ++n;
                    }
                    break block9;
                }
                ChangeSupport changeSupport = this.changeSupport;
                synchronized (changeSupport) {
                    ChangeEvent changeEvent = new ChangeEvent(this, Count.COUNTS);
                    this.changeSupport.firePreChangeEvent(changeEvent);
                    int n = 0;
                    while (n < this.counts.length) {
                        this.counts[n] = count.getCount((AtomicSymbol)this.indexer.symbolForIndex(n));
                        ++n;
                    }
                    this.changeSupport.firePostChangeEvent(changeEvent);
                }
            }
            catch (IllegalSymbolException illegalSymbolException) {
                throw new BioError(illegalSymbolException, "Assertion Failure: Should have no illegal symbols");
            }
        }
    }

    public void zeroCounts() throws ChangeVetoException {
        if (this.changeSupport == null) {
            int n = 0;
            while (n < this.counts.length) {
                this.counts[n] = 0.0;
                ++n;
            }
        } else {
            ChangeSupport changeSupport = this.changeSupport;
            synchronized (changeSupport) {
                ChangeEvent changeEvent = new ChangeEvent(this, Count.COUNTS);
                this.changeSupport.firePreChangeEvent(changeEvent);
                int n = 0;
                while (n < this.counts.length) {
                    this.counts[n] = 0.0;
                    ++n;
                }
                this.changeSupport.firePostChangeEvent(changeEvent);
            }
        }
    }
}

