/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dp;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.TranslatedDistribution;
import org.biojava.bio.dp.DP;
import org.biojava.bio.dp.DotState;
import org.biojava.bio.dp.EmissionState;
import org.biojava.bio.dp.MagicalState;
import org.biojava.bio.dp.MarkovModel;
import org.biojava.bio.dp.ModelInState;
import org.biojava.bio.dp.ModelTrainer;
import org.biojava.bio.dp.SimpleMarkovModel;
import org.biojava.bio.dp.State;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleReversibleTranslationTable;
import org.biojava.bio.symbol.SingletonAlphabet;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.Changeable;
import org.biojava.utils.SingletonList;

class FlatModel
implements MarkovModel,
Serializable {
    private final MarkovModel source;
    private final MarkovModel delegate;
    protected transient ChangeSupport changeSupport;

    public FlatModel(MarkovModel markovModel) throws IllegalSymbolException, IllegalAlphabetException {
        State state;
        Object object;
        Object object2;
        Changeable changeable;
        Changeable changeable2;
        Object object3;
        State state2;
        Object object4;
        this.source = markovModel;
        this.delegate = new SimpleMarkovModel(this.source.heads(), this.source.emissionAlphabet(), "flat");
        HashMap<Object, State> hashMap = new HashMap<Object, State>();
        HashMap<Object, Object> hashMap2 = new HashMap<Object, Object>();
        HashMap<State, Changeable> hashMap3 = new HashMap<State, Changeable>();
        HashMap<State, Changeable> hashMap4 = new HashMap<State, Changeable>();
        HashMap<Object, Changeable> hashMap5 = new HashMap<Object, Changeable>();
        HashMap<Object, Changeable> hashMap6 = new HashMap<Object, Changeable>();
        Iterator iterator = markovModel.stateAlphabet().iterator();
        while (iterator.hasNext()) {
            object4 = (State)iterator.next();
            if (object4 instanceof DotState) {
                state2 = new DotStateWrapper((State)object4);
                this.addAState(state2);
                hashMap2.put(object4, markovModel);
                hashMap.put(object4, state2);
                continue;
            }
            if (object4 instanceof EmissionState) {
                if (object4 instanceof MagicalState) {
                    hashMap5.put(markovModel, markovModel.magicalState());
                    hashMap6.put(markovModel, markovModel.magicalState());
                    continue;
                }
                state2 = new EmissionWrapper((EmissionState)object4);
                this.addAState(state2);
                hashMap2.put(object4, markovModel);
                hashMap.put(object4, state2);
                continue;
            }
            if (object4 instanceof ModelInState) {
                state2 = (ModelInState)object4;
                object3 = DP.flatView(state2.getModel());
                changeable2 = new DotStateWrapper(state2, "start");
                changeable = new DotStateWrapper(state2, "end");
                this.addAState((State)changeable2);
                this.addAState((State)changeable);
                hashMap2.put(state2, markovModel);
                hashMap5.put(object3, changeable2);
                hashMap6.put(object3, changeable);
                hashMap3.put(state2, changeable2);
                hashMap4.put(state2, changeable);
                object2 = object3.stateAlphabet().iterator();
                while (object2.hasNext()) {
                    object = (State)object2.next();
                    if (object instanceof DotState) {
                        state = new DotStateWrapper((State)object);
                        this.addAState(state);
                        hashMap2.put(object, object3);
                        hashMap.put(object, state);
                        hashMap.put(((Wrapper)object).getWrapped(), state);
                        continue;
                    }
                    if (object instanceof EmissionState) {
                        if (object instanceof MagicalState) continue;
                        state = new EmissionWrapper((EmissionState)object);
                        this.addAState(state);
                        hashMap2.put(object, object3);
                        hashMap.put(object, state);
                        continue;
                    }
                    throw new IllegalSymbolException((Symbol)object4, "Don't know how to handle state: " + object4.getName());
                }
                continue;
            }
            throw new IllegalSymbolException((Symbol)object4, "Don't know how to handle state: " + object4.getName());
        }
        object4 = this.delegate.stateAlphabet().iterator();
        while (object4.hasNext()) {
            state2 = (State)object4.next();
            if (state2 instanceof MagicalState) {
                object3 = state2;
                changeable2 = markovModel;
            } else {
                changeable = (Wrapper)state2;
                object2 = ((Wrapper)changeable).getWrapped();
                object = (MarkovModel)hashMap2.get(object2);
                if (object != markovModel) {
                    object3 = object2;
                    changeable2 = object;
                } else if (changeable instanceof ModelInState) {
                    if (changeable == hashMap5.get(object)) {
                        changeable2 = ((ModelInState)object2).getModel();
                        object3 = changeable2.magicalState();
                    } else {
                        changeable2 = markovModel;
                        object3 = object2;
                    }
                } else {
                    changeable2 = markovModel;
                    object3 = state2;
                }
            }
            changeable = TranslatedDistribution.getDistribution(this.delegate.transitionsFrom(state2), changeable2.getWeights((State)object3));
            object2 = (SimpleReversibleTranslationTable)((TranslatedDistribution)changeable).getTable();
            try {
                this.delegate.setWeights(state2, (Distribution)changeable);
            }
            catch (ChangeVetoException changeVetoException) {
                throw new BioError(changeVetoException, "Couldn't edit delegate model");
            }
            ((SimpleReversibleTranslationTable)object2).setTranslation(state2, (AtomicSymbol)object3);
            object = changeable2.transitionsFrom((State)object3).iterator();
            while (object.hasNext()) {
                state = (State)object.next();
                State state3 = state instanceof MagicalState ? (changeable2 == markovModel ? state : (State)hashMap6.get(changeable2)) : (State)hashMap.get(object3);
                ((SimpleReversibleTranslationTable)object2).setTranslation(state3, state);
            }
        }
    }

    protected void addAState(State state) throws IllegalSymbolException {
        try {
            this.delegate.addState(state);
        }
        catch (ChangeVetoException changeVetoException) {
            throw new BioError(changeVetoException, "This model should be ours with no listeners");
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.generateChangeSupport(null);
        this.changeSupport.addChangeListener(changeListener);
    }

    public void addChangeListener(ChangeListener changeListener, ChangeType changeType) {
        this.generateChangeSupport(changeType);
        this.changeSupport.addChangeListener(changeListener, changeType);
    }

    public void addState(State state) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("addState not supported by FlatModel");
    }

    public boolean containsTransition(State state, State state2) throws IllegalSymbolException {
        return this.delegate.containsTransition(state, state2);
    }

    public void createTransition(State state, State state2) throws IllegalSymbolException, UnsupportedOperationException {
        FiniteAlphabet finiteAlphabet = this.stateAlphabet();
        finiteAlphabet.validate(state);
        finiteAlphabet.validate(state2);
        throw new UnsupportedOperationException("createTransition not supported by FlatModel");
    }

    public void destroyTransition(State state, State state2) throws IllegalSymbolException, UnsupportedOperationException {
        FiniteAlphabet finiteAlphabet = this.stateAlphabet();
        finiteAlphabet.validate(state);
        finiteAlphabet.validate(state2);
        throw new UnsupportedOperationException("destroyTransition not supported by FlatModel");
    }

    public Alphabet emissionAlphabet() {
        return this.delegate.emissionAlphabet();
    }

    protected void generateChangeSupport(ChangeType changeType) {
        if (this.changeSupport == null) {
            this.changeSupport = new ChangeSupport();
        }
    }

    public Distribution getWeights(State state) throws IllegalSymbolException {
        return this.delegate.getWeights(state);
    }

    public int heads() {
        return this.delegate.heads();
    }

    public MagicalState magicalState() {
        return this.delegate.magicalState();
    }

    public void registerWithTrainer(ModelTrainer modelTrainer) {
        modelTrainer.registerModel(this.delegate);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener, ChangeType changeType) {
        this.changeSupport.removeChangeListener(changeListener, changeType);
    }

    public void removeState(State state) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("removeState not supported by FlatModel");
    }

    public void setWeights(State state, Distribution distribution) throws ChangeVetoException {
        throw new ChangeVetoException("Can't set weights in immutable view");
    }

    public FiniteAlphabet stateAlphabet() {
        return this.delegate.stateAlphabet();
    }

    public FiniteAlphabet transitionsFrom(State state) throws IllegalSymbolException {
        return this.delegate.transitionsFrom(state);
    }

    public FiniteAlphabet transitionsTo(State state) throws IllegalSymbolException {
        return this.delegate.transitionsTo(state);
    }

    private static class Wrapper
    implements State,
    Serializable {
        private final State wrapped;
        private final String extra;
        private final Alphabet matches;
        protected transient ChangeSupport changeSupport = null;

        public Wrapper(State state, String string) {
            if (state == null) {
                throw new NullPointerException("Can't wrap null");
            }
            this.wrapped = state;
            this.extra = string;
            this.matches = new SingletonAlphabet(this);
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.generateChangeSupport(null);
            this.changeSupport.addChangeListener(changeListener);
        }

        public void addChangeListener(ChangeListener changeListener, ChangeType changeType) {
            this.generateChangeSupport(changeType);
            this.changeSupport.addChangeListener(changeListener, changeType);
        }

        protected void generateChangeSupport(ChangeType changeType) {
            if (this.changeSupport == null) {
                this.changeSupport = new ChangeSupport();
            }
        }

        public Annotation getAnnotation() {
            return this.wrapped.getAnnotation();
        }

        public Set getBases() {
            return Collections.singleton(this);
        }

        public Alphabet getMatches() {
            return this.matches;
        }

        public String getName() {
            return String.valueOf(this.wrapped.getName()) + "-" + this.extra;
        }

        public List getSymbols() {
            return new SingletonList(this);
        }

        public char getToken() {
            return this.wrapped.getToken();
        }

        public State getWrapped() {
            return this.wrapped;
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.changeSupport.removeChangeListener(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener, ChangeType changeType) {
            this.changeSupport.removeChangeListener(changeListener, changeType);
        }
    }

    private static class DotStateWrapper
    extends Wrapper
    implements DotState {
        public DotStateWrapper(State state) throws NullPointerException {
            this(state, "f");
        }

        public DotStateWrapper(State state, String string) {
            super(state, string);
        }
    }

    private static class EmissionWrapper
    extends Wrapper
    implements EmissionState {
        public EmissionWrapper(EmissionState emissionState) {
            this(emissionState, "-f");
        }

        public EmissionWrapper(EmissionState emissionState, String string) {
            super(emissionState, string);
        }

        public int[] getAdvance() {
            return this.getWrappedES().getAdvance();
        }

        public Distribution getDistribution() {
            return this.getWrappedES().getDistribution();
        }

        private EmissionState getWrappedES() {
            return (EmissionState)this.getWrapped();
        }

        public void registerWithTrainer(ModelTrainer modelTrainer) {
        }

        public void setAdvance(int[] nArray) throws ChangeVetoException {
            this.getWrappedES().setAdvance(nArray);
        }

        public void setDistribution(Distribution distribution) throws ChangeVetoException {
            this.getWrappedES().setDistribution(distribution);
        }
    }
}

