/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dp;

import java.io.Serializable;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.DistributionFactory;
import org.biojava.bio.dp.WeightMatrix;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;

public class SimpleWeightMatrix
implements WeightMatrix,
Serializable {
    private final Distribution[] columns;
    private final Alphabet alpha;

    public SimpleWeightMatrix(Alphabet alphabet, int n, DistributionFactory distributionFactory) throws IllegalAlphabetException {
        this.alpha = alphabet;
        this.columns = new Distribution[n];
        int n2 = 0;
        while (n2 < n) {
            this.columns[n2] = distributionFactory.createDistribution(alphabet);
            ++n2;
        }
    }

    public SimpleWeightMatrix(Distribution[] distributionArray) throws IllegalAlphabetException {
        this.alpha = distributionArray[0].getAlphabet();
        int n = 0;
        while (n < distributionArray.length) {
            if (distributionArray[n].getAlphabet() != this.alpha) {
                throw new IllegalAlphabetException("All columns must emit the same alphabet. Expecting " + this.alpha.getName() + ", but found " + distributionArray[n].getAlphabet().getName());
            }
            ++n;
        }
        this.columns = distributionArray;
    }

    public int columns() {
        return this.columns.length;
    }

    public Alphabet getAlphabet() {
        return this.alpha;
    }

    public Distribution getColumn(int n) {
        return this.columns[n];
    }
}

