/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.biojava.bio.gui.sequence.LabelRenderer;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public class SimpleLabelRenderer
extends AbstractChangeable
implements LabelRenderer {
    private static final ChangeType LABEL = new ChangeType("The label has changed", "org.biojava.bio.gui.sequence.SimpleLabelRenderer", "LABEL", SequenceRenderContext.LAYOUT);
    private static final AffineTransform FLIP = new AffineTransform(0.0, 1.0, -1.0, 0.0, 0.0, 0.0);
    private String label;
    private Shape labelGlyphH;
    private Shape labelGlyphV;

    public String getLabel() {
        return this.label;
    }

    protected Shape getLabelGlyph(SequenceRenderContext sequenceRenderContext, FontRenderContext fontRenderContext) {
        Shape shape;
        if (sequenceRenderContext.getDirection() == 0) {
            if (this.labelGlyphH == null) {
                Font font = sequenceRenderContext.getFont();
                this.labelGlyphH = font.createGlyphVector(fontRenderContext, this.label).getOutline();
            }
            shape = this.labelGlyphH;
        } else {
            if (this.labelGlyphV == null) {
                Font font = sequenceRenderContext.getFont().deriveFont(FLIP);
                this.labelGlyphV = font.createGlyphVector(fontRenderContext, this.label).getOutline();
            }
            shape = this.labelGlyphV;
        }
        return shape;
    }

    public double getMinimumWidth(SequenceRenderContext sequenceRenderContext) {
        if (this.label == null) {
            return 0.0;
        }
        Font font = sequenceRenderContext.getFont();
        FontRenderContext fontRenderContext = new FontRenderContext(null, true, true);
        GlyphVector glyphVector = font.createGlyphVector(fontRenderContext, this.label);
        return glyphVector.getVisualBounds().getWidth();
    }

    public void paint(Graphics2D graphics2D, SequenceRenderContext sequenceRenderContext, int n, int n2, SequenceRenderContext.Border border) {
    }

    private void renderLabel(Graphics2D graphics2D, Shape shape, Rectangle2D rectangle2D, SequenceRenderContext sequenceRenderContext, SequenceRenderContext.Border border) {
        Rectangle2D rectangle2D2 = shape.getBounds2D();
        double d = 0.0;
        double d2 = 0.0;
        if (sequenceRenderContext.getDirection() == 0) {
            d2 = rectangle2D.getCenterY() - rectangle2D2.getCenterY();
            int n = border.getAlignment();
            if (n == 10) {
                d = rectangle2D.getMinX() - rectangle2D2.getMinX();
            } else if (n == 11) {
                d = rectangle2D.getMaxX() - rectangle2D2.getMaxX();
            } else if (n == 0) {
                d = rectangle2D.getCenterX() - rectangle2D2.getCenterX();
            }
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.translate(d, d2);
            graphics2D.fill(shape);
            graphics2D.draw(shape);
            graphics2D.setTransform(affineTransform);
        } else {
            d2 = rectangle2D.getCenterX() - rectangle2D2.getCenterX();
            int n = border.getAlignment();
            if (n == 10) {
                d = rectangle2D.getMinY() - rectangle2D2.getMinY();
            } else if (n == 11) {
                d = rectangle2D.getMaxY() - rectangle2D2.getMaxY();
            } else if (n == 0) {
                d = rectangle2D.getCenterY() - rectangle2D2.getCenterY();
            }
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.translate(d2, d);
            graphics2D.fill(shape);
            graphics2D.draw(shape);
            graphics2D.setTransform(affineTransform);
        }
    }

    public void setLabel(String string) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport changeSupport;
            ChangeSupport changeSupport2 = changeSupport = this.getChangeSupport(LABEL);
            synchronized (changeSupport2) {
                ChangeEvent changeEvent = new ChangeEvent(this, SequenceRenderContext.LAYOUT, null, null, new ChangeEvent(this, LABEL, this.label, string));
                changeSupport.firePreChangeEvent(changeEvent);
                this.label = string;
                this.labelGlyphH = null;
                this.labelGlyphV = null;
                changeSupport.firePostChangeEvent(changeEvent);
            }
        } else {
            this.label = string;
            this.labelGlyphH = null;
            this.labelGlyphV = null;
        }
    }
}

