/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.sax;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import org.biojava.bio.program.sax.NamespaceConfigurationIF;
import org.biojava.bio.program.sax.QName;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

abstract class AbstractNativeAppSAXParser
implements XMLReader,
NamespaceConfigurationIF {
    private HashMap oPrefixMap = new HashMap();
    protected ContentHandler oHandler = null;
    protected boolean tNamespaces = true;
    protected boolean tNamespacePrefixes = false;
    protected String oNamespacePrefix = "";
    protected String oFullNamespacePrefix = "";
    protected int iState;

    AbstractNativeAppSAXParser() {
    }

    public void addPrefixMapping(String string, String string2) {
        this.oPrefixMap.put(string, string2);
    }

    protected void changeState(int n) {
        this.iState = n;
    }

    protected void characters(char[] cArray, int n, int n2) throws SAXException {
        this.oHandler.characters(cArray, n, n2);
    }

    protected void endElement(QName qName) throws SAXException {
        this.oHandler.endElement(qName.getURI(), qName.getLocalName(), qName.getQName());
    }

    public ContentHandler getContentHandler() {
        return this.oHandler;
    }

    protected BufferedReader getContentStream(InputSource inputSource) {
        int n = 8192;
        InputSource inputSource2 = inputSource;
        if (inputSource2.getCharacterStream() != null) {
            BufferedReader bufferedReader = new BufferedReader(inputSource2.getCharacterStream(), n);
            return bufferedReader;
        }
        if (inputSource2.getByteStream() != null) {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputSource2.getByteStream()), n);
            return bufferedReader;
        }
        if (inputSource2.getSystemId() != null) {
            try {
                FileInputStream fileInputStream = new FileInputStream(inputSource2.getSystemId());
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream), n);
                return bufferedReader;
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println(fileNotFoundException.getMessage());
                System.out.println("Couldn't open file");
                System.exit(0);
            }
        }
        return null;
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public ErrorHandler getErrorHandler() {
        return null;
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotSupportedException("The feature \"" + string + "\" is not supported " + "in the biojava native SAX2 parsing framework.");
    }

    public String getNamespacePrefix() {
        return this.oNamespacePrefix;
    }

    public boolean getNamespacePrefixes() {
        return this.tNamespacePrefixes;
    }

    public boolean getNamespaces() {
        return this.tNamespaces;
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotSupportedException("This method is not supportedin the biojava native SAX2 parser.");
    }

    public String getURIFromPrefix(String string) {
        if (this.oPrefixMap.containsKey(string)) {
            return (String)this.oPrefixMap.get(string);
        }
        return null;
    }

    public void parse(String string) throws IOException, SAXException {
        this.parse(new InputSource(string));
    }

    public void parse(InputSource inputSource) throws IOException, SAXException {
    }

    public String prefix(String string) {
        return this.oFullNamespacePrefix.concat(string);
    }

    public void setContentHandler(ContentHandler contentHandler) {
        if (contentHandler == null) {
            throw new NullPointerException("ContentHandler is null");
        }
        this.oHandler = contentHandler;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
    }

    public void setEntityResolver(EntityResolver entityResolver) {
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals("http://xml.org/features/namespaces")) {
            this.setNamespaces(bl);
            if (!this.getNamespaces() && !this.getNamespacePrefixes()) {
                throw new SAXNotSupportedException("Illegal feature combination");
            }
            return;
        }
        if (string.equals("http://xml.org/features/namespace-prefixes")) {
            this.setNamespacePrefixes(bl);
            if (!this.getNamespaces() && !this.getNamespacePrefixes()) {
                throw new SAXNotSupportedException("Illegal feature combination");
            }
            return;
        }
        throw new SAXNotSupportedException("The feature \"" + string + "\" is not supported " + "in the biojava native SAX2 parsing framework.");
    }

    public void setNamespacePrefix(String string) {
        this.oNamespacePrefix = string;
        this.oFullNamespacePrefix = this.oNamespacePrefix.concat(":");
    }

    private void setNamespacePrefixes(boolean bl) {
        this.tNamespacePrefixes = bl;
    }

    private void setNamespaces(boolean bl) {
        this.tNamespaces = bl;
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotSupportedException("This method is not supportedin the biojava native SAX2 parser.");
    }

    protected void startElement(QName qName, Attributes attributes) throws SAXException {
        this.oHandler.startElement(qName.getURI(), qName.getLocalName(), qName.getQName(), attributes);
    }
}

