/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.sax;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.biojava.bio.program.sax.AbstractNativeAppSAXParser;
import org.biojava.bio.program.sax.QName;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ClustalWAlignmentSAXParser
extends AbstractNativeAppSAXParser {
    private AttributesImpl oAtts = new AttributesImpl();
    private ArrayList oHeader = new ArrayList();
    private QName oAttQName = new QName(this);
    private char[] aoChars;
    private String oSeqName;
    private String oTmpSeq;
    private StringBuffer oSeq = new StringBuffer();
    private HashMap oAlignment = new HashMap();
    private ArrayList oSeqNameList = new ArrayList();
    private static final int STARTUP = 0;
    private static final int IN_STREAM = 1;

    public ClustalWAlignmentSAXParser() {
        this.iState = 0;
        this.setNamespacePrefix("biojava");
    }

    private void appendToAlignment(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\t\r ");
        this.oSeqName = stringTokenizer.nextToken();
        this.oSeq.setLength(0);
        while (stringTokenizer.hasMoreTokens()) {
            this.oSeq.append(stringTokenizer.nextToken());
        }
        if (this.oAlignment.get(this.oSeqName) == null) {
            this.oAlignment.put(this.oSeqName, this.oSeq.toString());
            this.oSeqNameList.add(this.oSeqName);
        } else {
            this.oTmpSeq = (String)this.oAlignment.get(this.oSeqName);
            this.oAlignment.put(this.oSeqName, this.oTmpSeq.concat(this.oSeq.toString()));
        }
    }

    private void emitSequence(String string, String string2) throws SAXException {
        this.oAtts.clear();
        this.oAttQName.setQName("sequenceName");
        this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", string);
        this.startElement(new QName(this, this.prefix("Sequence")), this.oAtts);
        this.aoChars = string2.toCharArray();
        this.characters(this.aoChars, 0, this.aoChars.length);
        this.endElement(new QName(this, this.prefix("Sequence")));
    }

    private void interpret(BufferedReader bufferedReader, String string) throws SAXException {
        if (this.iState == 0) {
            this.oAtts.clear();
            this.startElement(new QName(this, this.prefix("SequenceCollection")), this.oAtts);
            this.changeState(1);
        }
        if (this.iState == 1 && this.lineIsRelevant(string)) {
            this.appendToAlignment(string);
        }
    }

    private boolean lineIsRelevant(String string) {
        return !string.trim().equals("") && !string.startsWith(" ") && !string.startsWith("CLUSTAL W (");
    }

    public void parse(InputSource inputSource) throws IOException, SAXException {
        String string = null;
        BufferedReader bufferedReader = this.getContentStream(inputSource);
        try {
            string = bufferedReader.readLine();
            while (string != null) {
                this.interpret(bufferedReader, string);
                string = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            System.out.println("Stream read interupted");
        }
        int n = 0;
        while (n < this.oSeqNameList.size()) {
            this.oSeqName = (String)this.oSeqNameList.get(n);
            this.emitSequence(this.oSeqName, (String)this.oAlignment.get(this.oSeqName));
            ++n;
        }
        this.endElement(new QName(this, this.prefix("SequenceCollection")));
        bufferedReader.close();
    }
}

