/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.biojava.bio.BioException;
import org.biojava.bio.SimpleAnnotation;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.symbol.AbstractRangeLocation;
import org.biojava.bio.symbol.CompoundLocation;
import org.biojava.bio.symbol.FuzzyLocation;
import org.biojava.bio.symbol.PointLocation;
import org.biojava.bio.symbol.RangeLocation;

class FeatureTableParser {
    private static final int WITHOUT = 0;
    private static final int WITHIN = 1;
    private static final int LOCATION = 2;
    private static final int ATTRIBUTE = 3;
    private int featureStatus = 0;
    private StringBuffer featureBuf;
    private StrandedFeature.Template featureTemplate;
    private String featureSource;
    private SeqIOListener listener;

    FeatureTableParser(SeqIOListener seqIOListener, String string) {
        this.listener = seqIOListener;
        this.featureSource = string;
        this.featureBuf = new StringBuffer();
    }

    private int countChar(String string, char c) {
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            if (string.charAt(n2) == c) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    private int countChar(StringBuffer stringBuffer, char c) {
        int n = 0;
        int n2 = 0;
        while (n2 < stringBuffer.length()) {
            if (stringBuffer.charAt(n2) == c) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public void endFeature() throws BioException {
        this.listener.endFeature();
        this.featureStatus = 0;
    }

    public void featureData(String string) throws BioException {
        switch (this.featureStatus) {
            case 2: {
                this.featureBuf.append(string);
                if (this.countChar(this.featureBuf, '(') != this.countChar(this.featureBuf, ')')) break;
                this.parseLocation(this.featureBuf.toString(), this.featureTemplate);
                this.listener.startFeature(this.featureTemplate);
                this.featureStatus = 1;
                break;
            }
            case 1: {
                if (string.charAt(0) == '/') {
                    if (this.countChar(string, '\"') % 2 == 0) {
                        this.processAttribute(string);
                        break;
                    }
                    this.featureBuf.setLength(0);
                    this.featureBuf.append(string);
                    this.featureStatus = 3;
                    break;
                }
                throw new BioException("Invalid line in feature body: " + string);
            }
            case 3: {
                if (this.countChar(this.featureBuf, ' ') > 0) {
                    this.featureBuf.append(" ");
                }
                this.featureBuf.append(string);
                if (this.countChar(this.featureBuf, '\"') % 2 != 0) break;
                this.processAttribute(this.featureBuf.toString());
                this.featureStatus = 1;
                break;
            }
        }
    }

    public boolean inFeature() {
        return this.featureStatus != 0;
    }

    private void parseLocation(String string, StrandedFeature.Template template) throws BioException {
        Object object;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        int n = -1;
        Object object2 = null;
        ArrayList<Object> arrayList = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "(),. ><", true);
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            if (((String)object).equals("join") || ((String)object).equals("order")) {
                bl = true;
                arrayList = new ArrayList<Object>();
                continue;
            }
            if (((String)object).equals("complement")) {
                bl2 = true;
                bl3 = true;
                continue;
            }
            if (((String)object).equals("(")) {
                ++n2;
                continue;
            }
            if (((String)object).equals(")")) {
                --n2;
                continue;
            }
            if (((String)object).equals(".") || ((String)object).equals(",")) continue;
            if (((String)object).equals(">")) {
                if (bl4) {
                    bl6 = true;
                    continue;
                }
                bl5 = true;
                continue;
            }
            if (((String)object).equals("<")) {
                if (bl4) {
                    bl6 = true;
                    continue;
                }
                bl5 = true;
                continue;
            }
            if (((String)object).equals(" ")) continue;
            int n3 = -1;
            try {
                n3 = Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new BioException("bad locator: " + (String)object + " " + string);
            }
            if (!bl4) {
                n = n3;
                bl4 = true;
                continue;
            }
            AbstractRangeLocation abstractRangeLocation = new RangeLocation(n, n3);
            abstractRangeLocation = bl5 || bl6 ? new FuzzyLocation(bl5 ? Integer.MIN_VALUE : n, bl6 ? Integer.MAX_VALUE : n3, n, n3, FuzzyLocation.RESOLVE_INNER) : new RangeLocation(n, n3);
            if (bl) {
                arrayList.add(abstractRangeLocation);
            } else {
                if (object2 != null) {
                    throw new BioException("Tried to set result to " + abstractRangeLocation + " when it was alredy set to " + object2);
                }
                object2 = abstractRangeLocation;
            }
            bl4 = false;
            bl2 = false;
            bl6 = false;
            bl5 = false;
        }
        if (n2 != 0) {
            throw new BioException("Mismatched parentheses: " + string);
        }
        if (bl4) {
            object = new PointLocation(n);
            if (bl) {
                arrayList.add(object);
            } else {
                if (object2 != null) {
                    throw new BioException();
                }
                object2 = object;
            }
        }
        template.strand = bl3 ? StrandedFeature.NEGATIVE : StrandedFeature.POSITIVE;
        if (object2 == null) {
            if (arrayList == null) {
                throw new BioException("Location null: " + string);
            }
            object2 = new CompoundLocation(arrayList);
        }
        template.location = object2;
    }

    private void processAttribute(String string) throws BioException {
        int n = string.indexOf(61);
        if (n == -1) {
            this.listener.addFeatureProperty(string.substring(1), Boolean.TRUE);
        } else {
            String string2;
            int n2;
            String string3 = string.substring(1, n);
            if (string.charAt(++n) == '\"') {
                ++n;
            }
            if (string.charAt((n2 = string.length()) - 1) == '\"') {
                --n2;
            }
            if ((string2 = string.substring(n, n2)).indexOf(34) >= 0) {
                StringBuffer stringBuffer = new StringBuffer();
                boolean bl = false;
                int n3 = 0;
                while (n3 < string2.length()) {
                    char c = string2.charAt(n3);
                    if (c == '\"') {
                        if (bl) {
                            stringBuffer.append(c);
                        }
                        bl ^= true;
                    } else {
                        stringBuffer.append(c);
                        bl = false;
                    }
                    ++n3;
                }
                string2 = stringBuffer.toString();
            }
            this.listener.addFeatureProperty(string3, string2);
        }
    }

    public void startFeature(String string) throws BioException {
        this.featureStatus = 2;
        this.featureBuf.setLength(0);
        this.featureTemplate = new StrandedFeature.Template();
        this.featureTemplate.type = string;
        this.featureTemplate.source = this.featureSource;
        this.featureTemplate.annotation = new SimpleAnnotation();
    }
}

