/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.stats.svm.tools;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import org.biojava.stats.svm.SVMClassifierModel;
import org.biojava.stats.svm.tools.SVM_Light;

public class Classify {
    public static void main(String[] stringArray) throws Throwable {
        String string;
        if (stringArray.length < 3) {
            throw new Exception("usage: stats.svm.tools.Classify <model> <test_examples> <results_log>");
        }
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        String string4 = stringArray[2];
        SVMClassifierModel sVMClassifierModel = SVM_Light.readModelFile(string2);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string3));
        PrintWriter printWriter = new PrintWriter(new FileWriter(string4));
        int n = 0;
        int n2 = 0;
        while ((string = bufferedReader.readLine()) != null) {
            if (string.length() == 0 || string.startsWith("#")) continue;
            SVM_Light.LabelledVector labelledVector = SVM_Light.parseExample(string);
            double d = sVMClassifierModel.classify(labelledVector.getVector());
            printWriter.println(d);
            if (Classify.sign(d) == Classify.sign(labelledVector.getLabel())) {
                ++n;
                continue;
            }
            ++n2;
        }
        System.out.println((double)n / (double)(n + n2) * 100.0 + "% correct");
        bufferedReader.close();
        printWriter.close();
    }

    public static int sign(double d) {
        if (d < 0.0) {
            return -1;
        }
        if (d == 0.0) {
            return 0;
        }
        return 1;
    }
}

