/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.bytecode;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.biojava.utils.bytecode.CodeContext;
import org.biojava.utils.bytecode.CodeException;
import org.biojava.utils.bytecode.CodeGenerator;
import org.biojava.utils.bytecode.Label;

public class InstructionVector
implements CodeGenerator {
    private List instructions;
    private Label endLabel = new Label();
    private Label startLabel = new Label();

    public InstructionVector() {
        this.instructions = new ArrayList();
    }

    public void add(CodeGenerator codeGenerator) {
        this.instructions.add(codeGenerator);
    }

    public int size() {
        return this.instructions.size();
    }

    public void add(int n, CodeGenerator codeGenerator) {
        this.instructions.add(n, codeGenerator);
    }

    public void remove(int n) {
        this.instructions.remove(n);
    }

    public CodeGenerator generatorAt(int n) {
        return (CodeGenerator)this.instructions.get(n);
    }

    public Label getStartLabel() {
        return this.startLabel;
    }

    public Label getEndLabel() {
        return this.endLabel;
    }

    public void writeCode(CodeContext codeContext) throws CodeException {
        CodeContext codeContext2 = codeContext.subContext();
        codeContext2.open();
        codeContext2.markLabel(this.startLabel);
        Iterator iterator = this.instructions.iterator();
        while (iterator.hasNext()) {
            CodeGenerator codeGenerator = (CodeGenerator)iterator.next();
            codeGenerator.writeCode(codeContext2);
        }
        codeContext2.markLabel(this.endLabel);
        codeContext2.close();
    }
}

