/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.scenegraph;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.biojava.utils.scenegraph.ChildManager;
import org.biojava.utils.scenegraph.Component;
import org.biojava.utils.scenegraph.NullChildManager;

public class Primative
extends Component {
    public static final int GEOMETRY = 4;
    public static final int BOUNDS = 8;
    private DrawMode drawMode;
    private int hitTestMode;
    private Shape shape;

    public DrawMode getDrawMode() {
        return this.drawMode;
    }

    public void setDrawMode(DrawMode drawMode) {
        this.drawMode = drawMode;
    }

    public int getHitTestMode() {
        return this.hitTestMode;
    }

    public void setHitTestMode(int n) {
        this.hitTestMode = n;
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setShape(Shape shape) {
        this.shape = shape;
        this.invalidateBounds();
    }

    public Primative(Shape shape) {
        this.setShape(shape);
        this.setDrawMode(DrawMode.BOTH);
        this.setHitTestMode(4);
    }

    public Primative(Shape shape, AffineTransform affineTransform) {
        this.setShape(shape);
        this.setDrawMode(DrawMode.BOTH);
        this.setHitTestMode(4);
        super.setTransform(affineTransform);
    }

    public void draw(Graphics2D graphics2D) {
        if (this.drawMode == DrawMode.FILL || this.drawMode == DrawMode.BOTH) {
            graphics2D.fill(this.shape);
        }
        if (this.drawMode == DrawMode.OUTLINE || this.drawMode == DrawMode.BOTH) {
            graphics2D.draw(this.shape);
        }
    }

    public Shape calculateBounds() {
        Rectangle2D rectangle2D = this.getShape().getBounds2D();
        if (rectangle2D.getWidth() == 0.0) {
            rectangle2D.add(rectangle2D.getMaxX() + 0.01, rectangle2D.getMaxY());
        }
        if (rectangle2D.getHeight() == 0.0) {
            rectangle2D.add(rectangle2D.getMaxX(), rectangle2D.getMaxY() + 0.01);
        }
        return rectangle2D;
    }

    public List contains(Point2D point2D) {
        if (this.getHitTestMode() == 8 || this.getShape().contains(point2D)) {
            return new ArrayList<Primative>(Collections.singleton(this));
        }
        return Collections.EMPTY_LIST;
    }

    public Iterator getChildIterator() {
        return Collections.EMPTY_LIST.iterator();
    }

    public ChildManager getChildManager() {
        return NullChildManager.instance;
    }

    public static final class DrawMode {
        private String name;
        public static final DrawMode NOTHING = new DrawMode("Nothing");
        public static final DrawMode OUTLINE = new DrawMode("Outline");
        public static final DrawMode FILL = new DrawMode("Fill");
        public static final DrawMode BOTH = new DrawMode("Both");

        private DrawMode(String string) {
            this.name = string;
        }

        public String toString() {
            return this.name;
        }
    }
}

