/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.alignment.hmm;

import edu.msu.cme.rdp.alignment.hmm.ProfileHMM;
import edu.msu.cme.rdp.alignment.hmm.TSC;
import edu.msu.cme.rdp.readseq.SequenceType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;

public class HMMER3bParser {
    public static ProfileHMM readModel(File f) throws IOException {
        return HMMER3bParser.readModel(new FileInputStream(f));
    }

    public static ProfileHMM readModel(InputStream is) throws IOException {
        ProfileHMM hmm = HMMER3bParser.readModelInternal(is);
        hmm.configureGlocal(true);
        return hmm;
    }

    public static ProfileHMM readUnnormalized(File f) throws IOException {
        return HMMER3bParser.readUnnormalized(new FileInputStream(f));
    }

    public static ProfileHMM readUnnormalized(InputStream is) throws IOException {
        ProfileHMM hmm = HMMER3bParser.readModelInternal(is);
        hmm.configureGlocal(false);
        return hmm;
    }

    private static ProfileHMM readModelInternal(InputStream is) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        ProfileHMM hmm = new ProfileHMM();
        hmm.version = reader.readLine().trim().split("\\s+")[0];
        if (!hmm.version.equals("HMMER3/b") && !hmm.version.equals("HMMER3/f")) {
            throw new IOException("Cannot parse " + hmm.version + " version hmmer model, only supports HMMER3/b");
        }
        String alpha = null;
        while ((line = reader.readLine()) != null) {
            String[] lexemes = line.trim().split("\\s+");
            if (lexemes[0].equals("NAME")) {
                hmm.name = lexemes[1];
                continue;
            }
            if (lexemes[0].equals("LENG")) {
                hmm.m = Integer.valueOf(lexemes[1]);
                continue;
            }
            if (lexemes[0].equals("ALPH")) {
                alpha = lexemes[1];
                if (alpha.equals("amino")) {
                    hmm.alphabet = SequenceType.Protein;
                    continue;
                }
                if (alpha.equals("RNA")) {
                    hmm.alphabet = SequenceType.Nucleotide;
                    continue;
                }
                if (alpha.equals("DNA")) {
                    hmm.alphabet = SequenceType.Nucleotide;
                    continue;
                }
                throw new IOException("Unknown sequence alphabet \"" + alpha + "\"");
            }
            if (!lexemes[0].equals("HMM")) continue;
            HMMER3bParser.parseAlpha(hmm, line);
            break;
        }
        if (hmm.m == null) {
            throw new IOException("Model length not found");
        }
        if (alpha == null) {
            throw new IOException("No alphabet specified in HMM");
        }
        reader.readLine();
        hmm.transitions = new double[8][hmm.m + 1];
        hmm.emissions = new double[hmm.m + 1][hmm.k][2];
        hmm.maxMatchEmissions = new double[hmm.m + 1];
        Arrays.fill(hmm.maxMatchEmissions, Double.NEGATIVE_INFINITY);
        line = reader.readLine().trim();
        if (line.startsWith("COMPO")) {
            hmm.compo = HMMER3bParser.readProbabilities(line, 1, hmm.k);
        }
        for (int index = 0; index <= hmm.m; ++index) {
            int emission;
            double[] probabilities;
            if (index > 0) {
                probabilities = HMMER3bParser.readProbabilities(reader.readLine(), 1, hmm.k);
                for (emission = 0; emission < hmm.k; ++emission) {
                    hmm.emissions[index][emission][0] = probabilities[emission];
                }
            }
            probabilities = HMMER3bParser.readProbabilities(reader.readLine(), 0, hmm.k);
            for (emission = 0; emission < hmm.k; ++emission) {
                hmm.emissions[index][emission][1] = probabilities[emission];
            }
            probabilities = HMMER3bParser.readProbabilities(reader.readLine(), 0, 7);
            for (int trans = 0; trans < 7; ++trans) {
                hmm.transitions[trans][index] = probabilities[trans];
            }
        }
        reader.close();
        return hmm;
    }

    private static void parseAlpha(ProfileHMM hmm, String line) throws IOException {
        String[] lexemes = line.trim().split("\\s+");
        hmm.alphaMapping = new int[127];
        Arrays.fill(hmm.alphaMapping, -1);
        for (int index = 1; index < lexemes.length; ++index) {
            if (lexemes[index].length() != 1) {
                throw new IOException("Alphabet symbol " + lexemes[index] + " too long");
            }
            char sym = Character.toUpperCase(lexemes[index].charAt(0));
            hmm.alphaMapping[sym] = index - 1;
            hmm.alphaMapping[Character.toLowerCase((char)sym)] = index - 1;
            if (sym != 'U' || hmm.alphabet != SequenceType.Nucleotide) continue;
            hmm.alphaMapping[84] = index - 1;
            hmm.alphaMapping[116] = index - 1;
        }
        hmm.k = lexemes.length - 1;
    }

    private static double[] readProbabilities(String line, int offset, int expectedValues) throws IOException {
        if (line == null || line.equals("//")) {
            throw new IOException("Unexpected end of model");
        }
        String[] lexemes = line.trim().split("\\s+");
        double[] ret = new double[expectedValues];
        if (lexemes.length < expectedValues + offset) {
            throw new IOException("Too few probabilities on line \"" + line + "\"");
        }
        for (int index = offset; index < offset + expectedValues; ++index) {
            if (lexemes[index].equals("*")) {
                ret[index - offset] = 0.0;
                continue;
            }
            double v = Double.valueOf(lexemes[index]);
            ret[index - offset] = StrictMath.exp(-1.0 * v);
        }
        return ret;
    }

    public static void main(String[] args) throws IOException {
        int state;
        ProfileHMM hmm = HMMER3bParser.readModel(new File("/work/fishjord/other_projects/hmmgs/models/rplb/rplb_for.hmm"));
        System.out.print("double expected_compo[] = {");
        for (int index = 0; index < hmm.compo.length; ++index) {
            System.out.print(hmm.compo[index]);
            if (index + 1 == hmm.compo.length) continue;
            System.out.print(",");
        }
        System.out.println("};");
        System.out.println("double expected_msc[][20] = {");
        for (state = 0; state < hmm.M() + 1; ++state) {
            System.out.print("\t{");
            for (int index = 0; index < hmm.compo.length; ++index) {
                if (hmm.msc(state, index) == Double.NEGATIVE_INFINITY) {
                    System.out.print("-std::numeric_limits<double>::infinity()");
                } else {
                    System.out.print(hmm.msc(state, index));
                }
                if (index + 1 == hmm.compo.length) continue;
                System.out.print(",");
            }
            System.out.print("}");
            if (state + 1 == hmm.M() + 1) continue;
            System.out.println(",");
        }
        System.out.println("};");
        System.out.println("double expected_tsc[][7] = {");
        for (state = 0; state < hmm.M() + 1; ++state) {
            System.out.print("\t{");
            for (TSC tsc : new TSC[]{TSC.MM, TSC.MI, TSC.MD, TSC.IM, TSC.II, TSC.DM, TSC.DD}) {
                if (hmm.tsc(state, tsc) == Double.NEGATIVE_INFINITY) {
                    System.out.print("-std::numeric_limits<double>::infinity()");
                } else {
                    System.out.print(hmm.tsc(state, tsc));
                }
                if (tsc == TSC.DD) continue;
                System.out.print(",");
            }
            System.out.print("}");
            if (state + 1 == hmm.M() + 1) continue;
            System.out.println(",");
        }
        System.out.println("};");
        System.out.print("double expected_max_emission[] = {");
        for (state = 0; state <= hmm.M(); ++state) {
            System.out.print(hmm.getMaxMatchEmission(state));
            if (state == hmm.M()) continue;
            System.out.println(", ");
        }
        System.out.println("};");
        System.out.println("double expected_m_hcost = " + hmm.getHCost().computeHeuristicCost('m', 0) + ";");
        System.out.println("double expected_d_hcost = " + hmm.getHCost().computeHeuristicCost('d', 0) + ";");
        System.out.println("double expected_i_hcost = " + hmm.getHCost().computeHeuristicCost('i', 0) + ";");
    }
}

