/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.alignment.hmm.jni;

import edu.msu.cme.rdp.alignment.hmm.jni.HMMER3Hit;
import edu.msu.cme.rdp.readseq.readers.Sequence;
import edu.msu.cme.rdp.readseq.readers.SequenceReader;
import java.io.File;

public class HMMER3 {
    private final int numModels;

    public HMMER3(String hmmdb) throws Exception {
        System.loadLibrary("hmmerwrapper");
        this.numModels = this.initHmmer(hmmdb);
    }

    public HMMER3(String hmmdb, String hmmerWrapperLib) throws Exception {
        System.load(hmmerWrapperLib);
        this.numModels = this.initHmmer(hmmdb);
    }

    public void finalize() throws Throwable {
        super.finalize();
        this.destroyHmmer();
    }

    public HMMER3Hit[] findHits(Sequence seq) {
        return this.hmmer3(seq.getSeqString());
    }

    public HMMER3Hit[] findHits(String seq) {
        return this.hmmer3(seq);
    }

    private native int initHmmer(String var1);

    private native void destroyHmmer();

    private native HMMER3Hit[] hmmer3(String var1);

    public static void main(String[] args) throws Exception {
        Sequence seq;
        if (args.length != 2) {
            System.err.println("USAGE: test <hmm> <seqs>");
            System.exit(1);
        }
        HMMER3 hmmer = new HMMER3(args[0]);
        SequenceReader reader = new SequenceReader(new File(args[1]));
        while ((seq = reader.readNextSequence()) != null) {
            for (HMMER3Hit hit : hmmer.findHits(seq)) {
                System.out.println(hit.modelName + "\t" + hit.bits + "\t" + hit.hmmStart + "\t" + hit.hmmEnd + "\t" + hit.seqStart + "\t" + hit.seqEnd);
                System.out.println(hit.alignedSeq);
            }
        }
    }
}

