/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.taxatree;

import edu.msu.cme.rdp.taxatree.Node;

public class Taxon
extends Node {
    public static Taxon ROOT_TAXON = new Taxon(0, "Root", "no rank");
    private String name;
    private String rank;
    private boolean unclassified = false;

    public static int getUnclassifiedId(int id) {
        return -id - 1;
    }

    public Taxon(int taxid, String name, String rank) {
        this(taxid, name, rank, false);
    }

    public Taxon(Taxon copy) {
        this(copy.getTaxid(), copy.getName(), copy.getRank(), copy.isUnclassified());
    }

    public Taxon(int taxid, String name, String rank, boolean unclassified) {
        super(taxid);
        this.name = name;
        this.rank = rank;
        this.unclassified = unclassified;
    }

    public int getTaxid() {
        if (this.unclassified) {
            return Taxon.getUnclassifiedId(this.taxid);
        }
        return this.taxid;
    }

    public String getName() {
        if (this.unclassified) {
            return "unclassified_" + this.name;
        }
        return this.name;
    }

    public String getRank() {
        if (this.unclassified) {
            return "";
        }
        return this.rank;
    }

    public boolean isUnclassified() {
        return this.unclassified;
    }
}

