/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.classifier.train.validation.leaveoneout;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;

public class CompareMisclassified {
    private HashMap<String, String> misSeqMap = new HashMap();
    private String testrank = null;
    private int totalMissed = 0;

    public CompareMisclassified(String lootFile, String distFile) throws IOException {
        this.readLootResult(lootFile);
        this.readTaxonDistance(distFile);
    }

    private void readLootResult(String lootFile) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(new File(lootFile)));
        String line = null;
        boolean add = false;
        boolean singleton = false;
        while ((line = reader.readLine()) != null) {
            if (!line.startsWith("test rank")) continue;
            this.testrank = line.split(":")[1].trim();
            break;
        }
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("**misclassified sequences")) {
                add = true;
                continue;
            }
            if (line.startsWith("**singleton sequences")) {
                add = false;
                singleton = true;
                continue;
            }
            if (!line.startsWith("SEQ")) continue;
            String[] values = line.split("\\s+");
            if (add) {
                line = reader.readLine().trim();
                String[] lineage = line.split("\\t");
                this.misSeqMap.put(values[1], lineage[lineage.length - 2]);
                ++this.totalMissed;
                continue;
            }
            if (!singleton) continue;
            this.misSeqMap.remove(values[1]);
        }
        reader.close();
    }

    public void readTaxonDistance(String distFile) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(new File(distFile)));
        String line = null;
        int closerOutgrp = 0;
        int closerInGrp = 0;
        int equalGrp = 0;
        while ((line = reader.readLine()) != null && !line.startsWith("#")) {
            String[] values = line.split("\t");
            int ingrpSab = Integer.parseInt(values[1]);
            int outgrpinSab = Integer.parseInt(values[2]);
            if (!this.misSeqMap.containsKey(values[0])) continue;
            if (ingrpSab > outgrpinSab) {
                ++closerInGrp;
                continue;
            }
            if (ingrpSab == outgrpinSab) {
                ++equalGrp;
                continue;
            }
            ++closerOutgrp;
        }
        reader.close();
        System.out.println("totalMissed\tnon-singleton\tcloserOutgrp\tcloserInGrp\tequalGrp");
        System.out.println(this.totalMissed + "\t" + this.misSeqMap.size() + "\t" + closerOutgrp + "\t" + closerInGrp + "\t" + equalGrp);
    }

    public static void main(String[] args) throws IOException {
        CompareMisclassified theobj = new CompareMisclassified(args[0], args[1]);
    }
}

