/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.readseq.utils;

import edu.msu.cme.rdp.readseq.readers.Sequence;
import edu.msu.cme.rdp.readseq.readers.SequenceReader;
import edu.msu.cme.rdp.readseq.writers.FastaWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeqFileSplitter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<File> splitSeqFile(File seqFile, File outDir, int seqsPerSplit) throws IOException {
        if (!outDir.exists() && !outDir.mkdirs()) {
            throw new IOException("Output directory " + outDir + " doesn't exist and attempt to create failed");
        }
        if (!outDir.isDirectory()) {
            throw new IOException("Output directory " + outDir + " isn't a directory");
        }
        SequenceReader seqReader = new SequenceReader(seqFile);
        FastaWriter out = null;
        ArrayList<File> ret = new ArrayList<File>();
        try {
            Sequence seq;
            int splitno = 0;
            int seqsWritten = 0;
            String seqFileName = seqFile.getName();
            File split = new File(outDir, splitno++ + "_" + seqFileName);
            ret.add(split);
            out = new FastaWriter(split);
            while ((seq = seqReader.readNextSequence()) != null) {
                if (seqsWritten >= seqsPerSplit) {
                    out.close();
                    split = new File(outDir, splitno++ + "_" + seqFileName);
                    ret.add(split);
                    out = new FastaWriter(split);
                    seqsWritten = 0;
                }
                out.writeSeq(seq);
                ++seqsWritten;
            }
            ArrayList<File> arrayList = ret;
            return arrayList;
        }
        finally {
            seqReader.close();
            if (out != null) {
                out.close();
            }
        }
    }

    public static void main(String[] args) throws IOException {
        String usage = "Usage: SeqFileSplitter infile outdir seq_per_split";
        if (args.length != 3) {
            System.err.println(usage);
            return;
        }
        int seqpersplit = Integer.parseInt(args[2]);
        if (seqpersplit < 1) {
            System.err.println(usage);
            return;
        }
        SeqFileSplitter.splitSeqFile(new File(args[0]), new File(args[1]), seqpersplit);
    }
}

