/*
 * Decompiled with CFR 0.152.
 */
package de.proteinms.xtandemparser.viewer;

import com.jgoodies.looks.Options;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.looks.plastic.PlasticXPLookAndFeel;
import com.jgoodies.looks.plastic.theme.SkyKrupp;
import de.proteinms.xtandemparser.viewer.XTandemViewer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;

public class FileSelector
extends JFrame {
    private JPanel loadxmlPanel = null;
    private JTextField xmlSourceField = null;
    private JButton xmlfileBrow = null;
    private String filename = null;
    private JPanel lowerPanel = null;
    private JButton okBtn = null;
    private JPanel upperPanel = null;
    private JButton cancelBtn = null;
    private JPanel centerPanel = null;
    private JFrame iParent = null;

    public FileSelector(JFrame aParent, String title) {
        super(title);
        this.iParent = aParent;
        this.constructScreen();
    }

    public static void main(String[] args) {
        new FileSelector(null, "XTandem-Parser");
    }

    private void constructScreen() {
        this.setTitle("X!Tandem Viewer");
        this.configureUI();
        Container cp = this.getContentPane();
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/xtandemviewer.gif")));
        this.loadxmlPanel = new JPanel(new FlowLayout());
        this.xmlSourceField = new JTextField(35);
        this.xmlSourceField.setEditable(false);
        this.xmlSourceField.setEnabled(false);
        this.loadxmlPanel.add(this.xmlSourceField);
        this.xmlfileBrow = new JButton(this.openFileAction());
        this.loadxmlPanel.add(this.xmlfileBrow);
        this.upperPanel = new JPanel(new BorderLayout());
        this.upperPanel.setBorder(BorderFactory.createTitledBorder("Load X!Tandem Output"));
        this.upperPanel.add((Component)this.loadxmlPanel, "Center");
        this.lowerPanel = new JPanel();
        this.okBtn = new JButton("OK");
        this.okBtn.setPreferredSize(new Dimension(100, 20));
        this.okBtn.setEnabled(false);
        this.okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileSelector.this.okButtonActionPerformed();
            }
        });
        this.cancelBtn = new JButton("Cancel");
        this.cancelBtn.setPreferredSize(new Dimension(100, 20));
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FileSelector.this.cancelButtonActionPerformed();
            }
        });
        this.lowerPanel.add(this.okBtn);
        this.lowerPanel.add(this.cancelBtn);
        mainPanel.add((Component)this.upperPanel, "North");
        mainPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.centerPanel = new JPanel();
        mainPanel.add((Component)this.centerPanel, "Center");
        mainPanel.add((Component)this.lowerPanel, "South");
        cp.add(mainPanel);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                FileSelector.this.cancelButtonActionPerformed();
            }
        });
        this.setResizable(false);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void configureUI() {
        try {
            UIManager.put("Application.useSystemFontSettings", Boolean.TRUE);
            Options.setDefaultIconSize((Dimension)new Dimension(30, 30));
            PlasticLookAndFeel.setPlasticTheme((PlasticTheme)new SkyKrupp());
            UIManager.setLookAndFeel((LookAndFeel)new PlasticXPLookAndFeel());
        }
        catch (Exception e) {
            System.err.println("Can't set look & feel:" + e.getMessage());
        }
    }

    private void okButtonActionPerformed() {
        this.setVisible(false);
        new XTandemViewer(this.xmlSourceField.getText(), "user.home");
        if (this.iParent != null) {
            this.iParent.dispose();
        }
        this.dispose();
    }

    private void cancelButtonActionPerformed() {
        if (this.iParent == null) {
            System.exit(0);
        } else if (!this.iParent.isVisible()) {
            System.exit(0);
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    private Action openFileAction() {
        this.filename = System.getProperty("user.dir") + File.separator;
        JFileChooser fc = new JFileChooser(new File(this.filename));
        JFrame loadFrame = new JFrame();
        return new OpenFileAction(loadFrame, fc);
    }

    private static class InnerXmlFileFilter
    extends FileFilter {
        private InnerXmlFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getName().toLowerCase().endsWith(".xml");
        }

        @Override
        public String getDescription() {
            return "*.xml";
        }
    }

    public class OpenFileAction
    extends AbstractAction {
        private JFrame frame;
        private JFileChooser chooser;
        private InnerXmlFileFilter filter;
        private File file;
        private String name;

        OpenFileAction(JFrame frame, JFileChooser chooser) {
            super("Open XML-File...");
            this.filter = new InnerXmlFileFilter();
            this.file = null;
            this.name = null;
            this.chooser = chooser;
            this.frame = frame;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.chooser.setFileFilter(this.filter);
            this.chooser.showOpenDialog(this.frame);
            this.file = this.chooser.getSelectedFile();
            if (this.file != null) {
                this.name = this.file.getAbsolutePath();
                FileSelector.this.xmlSourceField.setText(this.name);
                FileSelector.this.xmlSourceField.setEnabled(true);
                FileSelector.this.okBtn.setEnabled(true);
            }
        }
    }
}

