## ----setup, echo=FALSE-----------------------------------------------------
knitr::opts_chunk$set(collapse=TRUE,comment = "#>")
suppressPackageStartupMessages(library(universalmotif))
suppressMessages(suppressPackageStartupMessages(library(MotifDb)))
suppressPackageStartupMessages(library(TFBSTools))
data(examplemotif)
data(MA0003.2)

## --------------------------------------------------------------------------
library(universalmotif)
data(examplemotif)
examplemotif

## --------------------------------------------------------------------------
library(universalmotif)
data(examplemotif)

## The various slots can be accessed individually using `[`

examplemotif["consensus"]

## To change a slot, use `[<-`

examplemotif["family"] <- "My motif family"
examplemotif

## ----error=TRUE------------------------------------------------------------
library(universalmotif)
data(examplemotif)

## The consensus slot is dependent on the motif matrix

examplemotif["consensus"]

## Changing this would mean it no longer matches the motif

examplemotif["consensus"] <- "GGGAGAG"

## Another example of trying to change a protected slot:

examplemotif["strand"] <- "x"

## --------------------------------------------------------------------------
library(universalmotif)
library(MotifDb)
data(examplemotif)
data(MA0003.2)

## convert from a `universalmotif` motif to another class

convert_motifs(examplemotif, "TFBSTools-PWMatrix")

## convert to universalmotif

convert_motifs(MA0003.2)

## convert between two packages

convert_motifs(MotifDb[1], "TFBSTools-ICMatrix")

## --------------------------------------------------------------------------
library(universalmotif)
data(examplemotif)

## This motif is currently a PPM:

examplemotif["type"]

## --------------------------------------------------------------------------
convert_type(examplemotif, "PCM")

## --------------------------------------------------------------------------
examplemotif["pseudocount"]
convert_type(examplemotif, "PWM")

## --------------------------------------------------------------------------
convert_type(examplemotif, "PWM", pseudocount = 1)

## --------------------------------------------------------------------------
examplemotif["nsites"] <- 10
convert_type(examplemotif, "ICM", nsize_correction = FALSE)

convert_type(examplemotif, "ICM", nsize_correction = TRUE)

examplemotif["bkg"] <- c(0.4, 0.1, 0.1, 0.4)
convert_type(examplemotif, "ICM", relative_entropy = TRUE)

## --------------------------------------------------------------------------
library(universalmotif)
library(MotifDb)

## No need to convert class, most universalmotif functions will do it
## automatically

motifs.dist <- compare_motifs(MotifDb[1:5], progress = FALSE)
as.dist(motifs.dist)

## Additionally P-value calculations can be performed for requested
## comparisons

compare_motifs(MotifDb[1:5], 1:5, progress = FALSE)

## --------------------------------------------------------------------------
library(universalmotif)
library(MotifDb)

motifs <- convert_motifs(MotifDb[1:5])

## Let us peek at the motifs before merging:

summarise_motifs(motifs)

## Now merge:

merge_motifs(motifs)

## --------------------------------------------------------------------------
library(universalmotif)
data(examplemotif)

## Quickly switch to the reverse complement of a motif

## Original:

examplemotif

## Reverse complement:

motif_rc(examplemotif)

## --------------------------------------------------------------------------
library(universalmotif)
data(examplemotif)

## DNA --> RNA

switch_alph(examplemotif)

## RNA --> DNA

motif <- create_motif(alphabet = "RNA")
motif

switch_alph(motif)

## --------------------------------------------------------------------------
library(universalmotif)

motif <- create_motif("NNGCSGCGGNN")
motif

trim_motifs(motif)

## --------------------------------------------------------------------------
motif.matrix <- matrix(c(0.7, 0.1, 0.1, 0.1,
                         0.7, 0.1, 0.1, 0.1,
                         0.1, 0.7, 0.1, 0.1,
                         0.1, 0.7, 0.1, 0.1,
                         0.1, 0.1, 0.7, 0.1,
                         0.1, 0.1, 0.7, 0.1,
                         0.1, 0.1, 0.1, 0.7,
                         0.1, 0.1, 0.1, 0.7), nrow = 4)

motif <- create_motif(motif.matrix, alphabet = "RNA", name = "My motif",
                      pseudocount = 1, nsites = 20, strand = "+")

## The 'type', 'icscore' and 'consensus' slots will be filled for you

motif

## --------------------------------------------------------------------------
motif <- create_motif("CCNSNGG", nsites = 50, pseudocount = 1)

## Now to disk:
## write_meme(motif, "meme_motif.txt")

motif

## --------------------------------------------------------------------------
create_motif()

## --------------------------------------------------------------------------
create_motif(bkg = c(0.2, 0.4, 0.2, 0.2))

## --------------------------------------------------------------------------
create_motif(alphabet = "QWERTY")

## --------------------------------------------------------------------------
library(universalmotif)
data(examplemotif)

## With the native `view_motifs` function:
view_motifs(examplemotif)

## For all the following examples, simply passing the functions a PPM is
## sufficient
motif <- convert_type(examplemotif, "PPM")
## Only need the matrix itself
motif <- motif["motif"]

## seqLogo:
seqLogo::seqLogo(motif)

## motifStack:
motifStack::plotMotifLogo(motif)

## Logolas:
colnames(motif) <- seq_len(ncol(motif))
Logolas::logomaker(motif, type = "Logo")

## ggseqlogo:
ggseqlogo::ggseqlogo(motif)

## --------------------------------------------------------------------------
library(universalmotif)
library(MotifDb)

motifs <- convert_motifs(MotifDb[1:3])
view_motifs(motifs)

## --------------------------------------------------------------------------
library(universalmotif)
library(MotifDb)

## Let us extract all of the Arabidopsis and C. elegans motifs (note that
## conversion from the MotifDb format is terminal)

motifs <- filter_motifs(MotifDb, organism = c("Athaliana", "Celegans"))

## Only keeping motifs with sufficient information content and length:

motifs <- filter_motifs(motifs, icscore = 10, width = 10)

head(summarise_motifs(motifs))

## --------------------------------------------------------------------------
library(universalmotif)
data(examplemotif)

sample_sites(examplemotif)

## --------------------------------------------------------------------------
library(universalmotif)
library(MotifDb)

motifs <- convert_motifs(MotifDb[1:50])
head(summarise_motifs(motifs))

motifs.shuffled <- shuffle_motifs(motifs, k = 3)
head(summarise_motifs(motifs.shuffled))

## ----sessionInfo, echo=FALSE-----------------------------------------------
sessionInfo()

