#!/bin/bash
#
set -e # Exit immediately if a simple command exits with a non-zero status.

DOWNLOAD_URL="ftp://ftp.ncbi.nih.gov/snp/organisms/human_9606/ASN1_flat"
FLAT_FILES="ch1 ch2 ch3 ch4 ch5 ch6 ch7 ch8 ch9 ch10 ch11 ch12 ch13 ch14 ch15 ch16 ch17 ch18 ch19 ch20 ch21 ch22 chX chY"

FLAT_PREFIX="ds_flat_"
FLAT_SUFFIX=".flat.gz"

if [ -e .listing ]; then
	echo "The current directory already contains a .listing file, which was probably generated "
	echo "by a previous run of this script. Please remove it (and eventually clean the current "
	echo "directory) before you run this script again. Alternatively, run this script in "
	echo "another directory."
	echo ""
	exit -1
fi

echo "Listing of files available at $DOWNLOAD_URL:"
A_VERY_UNLIKELY_FILENAME="z8y1991xYYuiI703f@44XaYuu"
wget --quiet --no-remove-listing "$DOWNLOAD_URL/$A_VERY_UNLIKELY_FILENAME*"
cat .listing
echo ""

for file in $FLAT_FILES; do
	filename="${FLAT_PREFIX}${file}${FLAT_SUFFIX}"
	url="$DOWNLOAD_URL/$filename"
	echo "Downloading $url ..."
	wget --no-verbose "$url"
	echo ""
done

echo "DONE."
echo ""

echo "A listing of all the files available at $DOWNLOAD_URL"
echo "at the time of the download was dumped in the .listing file."

