/*
 * Compile with
 *   gcc -Wall filter2_ds_flat.c -o filter2_ds_flat
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h> /* for isspace() */

#define LINEBUF_SIZE 20001

int rtrim(char *linebuf)
{
	int i;

	i = strlen(linebuf) - 1;
	while (i >= 0 && isspace(linebuf[i])) i--;
	linebuf[++i] = 0;
	return i;
}

int main(int argc, char *argv[])
{
	int status, inlineno, outlineno, nchar_in_inbuf;
	char inbuf[LINEBUF_SIZE];

	status = 1;
	inlineno = outlineno = 0;
	while (fgets(inbuf, LINEBUF_SIZE, stdin) != NULL) {
		inlineno++;
		nchar_in_inbuf = rtrim(inbuf);
		if (nchar_in_inbuf >= LINEBUF_SIZE - 1) { // should never be >
			fprintf(stderr, "input line %d is too long", inlineno);
			return -1;
		}
		switch (status) {
			case 1: case 5:
			if (status == 5) {
				if (strncmp(inbuf, "CTG", 3) == 0) {
					fprintf(stdout, " | %s", inbuf);
					continue;
				}
				fprintf(stdout, "\n");
				outlineno++;
			}
			if (strncmp(inbuf, "rs", 2) != 0) {
				fprintf(stderr, "\"rs\" expected at beginning of input line %d", inlineno);
				return -1;
			}
			fprintf(stdout, "%s", inbuf);
			status = 2;
			break;

			case 2:
			if (strncmp(inbuf, "SNP", 3) != 0) {
				fprintf(stderr, "\"SNP\" expected at beginning of input line %d", inlineno);
				return -1;
			}
			fprintf(stdout, " | %s", inbuf);
			status = 3;
			break;

			case 3:
			if (strncmp(inbuf, "VAL", 3) != 0) {
				fprintf(stderr, "\"VAL\" expected at beginning of input line %d", inlineno);
				return -1;
			}
			fprintf(stdout, " | %s", inbuf);
			status = 4;
			break;

			case 4:
			if (strncmp(inbuf, "CTG", 3) != 0) {
				fprintf(stderr, "\"CTG\" expected at beginning of input line %d", inlineno);
				return -1;
			}
			fprintf(stdout, " | %s", inbuf);
			status = 5;
			break;
		}
	}
	fprintf(stdout, "\n");
	return 0;
}

