## ----lib-------------------------------------------------------------------
suppressPackageStartupMessages(library(CNPBayes))
suppressPackageStartupMessages(library(SummarizedExperiment))
library(ggplot2)

## ----find_cnps-------------------------------------------------------------
se <- readRDS(system.file("extdata", "simulated_se.rds", package="CNPBayes"))
grl <- readRDS(system.file("extdata", "grl_deletions.rds", package="CNPBayes"))

## ----summary, message=FALSE------------------------------------------------
cnv.region <- consensusCNP(grl, max.width=5e6)
i <- subjectHits(findOverlaps(cnv.region, rowRanges(se)))
med.summary <- matrixStats::colMedians(assays(se)[["cn"]][i, ], na.rm=TRUE)

## ----model_construction----------------------------------------------------
mp <- McmcParams(nStarts=5, burnin=500, iter=1000, thin=1)

## ----gibbs-----------------------------------------------------------------
model.list <- gibbs(model="SB", dat=med.summary, k_range=c(2, 3), mp=mp,
                    max_burnin=400, top=2)

## ----ggfunctions-----------------------------------------------------------
model <- model.list[[1]]
model
chains <- ggChains(model)
chains[[1]]
chains[[2]]

## ----posteriorPredictive---------------------------------------------------
tab <- posteriorPredictive(model)
tab
ggPredictive(model, tab) + xlab("median LRR")

## ----cn_model--------------------------------------------------------------
cn.model <- CopyNumberModel(model)
ggMixture(cn.model)

## ----probCopyNumber--------------------------------------------------------
probs <- probCopyNumber(cn.model)
head(probs)

## ----downsample------------------------------------------------------------
mb <- MultiBatchModelExample
tiled.medians <- tileMedians(y(mb), 200, batch(mb))
tile.summaries <- tileSummaries(tiled.medians)
tile.summaries

## ----fit_downsample--------------------------------------------------------
model <- gibbs(model="MB", k_range=c(3, 3),
               dat=tile.summaries$avgLRR,
               batches=tile.summaries$batch,
               mp=mp)[[1]]

## ----upSample--------------------------------------------------------------
model2 <- upSample(model, tiled.medians)
model2

## ----copy-number-model-----------------------------------------------------
cn.model <- CopyNumberModel(model2)
mapping(cn.model)
round(head(probz(cn.model)), 2)
round(head(probCopyNumber(cn.model)), 2)

